package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArgs;

/**
 * Specialization of {@link AbstractStringChecker} that checks that a string does not contain
 * any outer (leading or trailing) {@link Character#isSpaceChar(int) space} character.
 */
public final class HasNoOuterSpaces extends AbstractStringChecker {
    public static final HasNoOuterSpaces INSTANCE = new HasNoOuterSpaces();

    public static final Factory<HasNoOuterSpaces> FACTORY =
            new AbstractFactory<HasNoOuterSpaces>(HasNoOuterSpaces.class) {
                @Override
                protected HasNoOuterSpaces create(Args args,
                                                  FormalArgs fargs) {
                    return INSTANCE;
                }
            };

    @Override
    public boolean test(String value) {
        if (value == null || value.isEmpty()) {
            return true;
        } else {
            if (Character.isSpaceChar(firstCodePoint(value))) {
                return false;
            }
            if (Character.isSpaceChar(lastCodePoint(value))) {
                return false;
            }
            return true;
        }
    }

    @Override
    public String explain(boolean result,
                          String arg) {
        if (result) {
            return wrap(arg) + " has no outer spaces";
        } else {
            return wrap(arg) + " has outer spaces";
        }
    }
}