package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArgs;

/**
 * Specialization of {@link AbstractStringChecker} that checks that a string does not contain
 * any outer (leading or trailing) {@link Character#isWhitespace(int) white space} character.
 */
public final class HasNoOuterWhiteSpaces extends AbstractStringChecker {
    public static final HasNoOuterWhiteSpaces INSTANCE = new HasNoOuterWhiteSpaces();

    public static final Factory<HasNoOuterWhiteSpaces> FACTORY =
            new AbstractFactory<HasNoOuterWhiteSpaces>(HasNoOuterWhiteSpaces.class) {
                @Override
                protected HasNoOuterWhiteSpaces create(Args args,
                                                       FormalArgs fargs) {
                    return INSTANCE;
                }
            };

    @Override
    public boolean test(String value) {
        if (value == null || value.isEmpty()) {
            return true;
        } else {
            if (Character.isWhitespace(firstCodePoint(value))) {
                return false;
            }
            if (Character.isWhitespace(lastCodePoint(value))) {
                return false;
            }
            return true;
        }
    }

    @Override
    public String explain(boolean result,
                          String arg) {
        if (result) {
            return wrap(arg) + " has no outer white spaces";
        } else {
            return wrap(arg) + " has outer white spaces";
        }
    }
}