package cdc.validation.checkers.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArgs;

/**
 * Specialization of {@link AbstractStringChecker} that checks that a string does not contain
 * any {@link Character#isWhitespace(int) white space} character.
 */
public final class HasNoWhiteSpaces extends AbstractStringChecker {
    public static final HasNoWhiteSpaces INSTANCE = new HasNoWhiteSpaces();

    public static final Factory<HasNoWhiteSpaces> FACTORY =
            new AbstractFactory<HasNoWhiteSpaces>(HasNoWhiteSpaces.class) {
                @Override
                protected HasNoWhiteSpaces create(Args args,
                                                  FormalArgs fargs) {
                    return INSTANCE;
                }
            };

    @Override
    public boolean test(String value) {
        if (value == null) {
            return true;
        } else {
            return value.codePoints()
                        .noneMatch(Character::isWhitespace);
        }
    }

    @Override
    public String explain(boolean result,
                          String arg) {
        if (result) {
            return wrap(arg) + " has no white spaces";
        } else {
            return wrap(arg) + " has white spaces";
        }
    }
}