/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import stack.source.internal.Index;
import stack.source.internal.IndexRegion;
import stack.source.internal.Throwables;

public final class Decorator {
    private final Throwable throwable;
    private final Map<String, Optional<Index>> indexes = new HashMap<String, Optional<Index>>();
    private final Map<StackTraceElement, String> snippets = new HashMap<StackTraceElement, String>();
    private final Set<Map.Entry<Index, IndexRegion>> printedRegions = new HashSet<Map.Entry<Index, IndexRegion>>();

    public Decorator(Throwable throwable) {
        this.throwable = Objects.requireNonNull(throwable);
    }

    public void printSafely(PrintStream out) {
        this.printSafely(new PrintWriter(out));
    }

    public void printSafely(PrintWriter out) {
        try {
            out.println(this.print());
        }
        catch (Throwable e) {
            this.throwable.printStackTrace(out);
            Logger.getLogger(this.getClass().getName()).warning(() -> "Failed to decorate " + Throwables.getStackTraceAsString(e));
        }
    }

    public String print() throws IOException {
        int i;
        StackTraceElement[] stacks = this.throwable.getStackTrace();
        for (i = 0; i < stacks.length && this.snippets.size() < 1; ++i) {
            this.read(stacks[i]);
        }
        for (int j = stacks.length - 1; j >= i && this.snippets.size() < 3; --j) {
            this.read(stacks[j]);
        }
        return this.snippets.entrySet().stream().reduce(Throwables.getStackTraceAsString(this.throwable), (str, entry) -> {
            String line = ((StackTraceElement)entry.getKey()).toString();
            return str.replace(line, line + System.lineSeparator() + System.lineSeparator() + (String)entry.getValue() + System.lineSeparator());
        }, (a, b) -> {
            throw new UnsupportedOperationException();
        });
    }

    private void read(StackTraceElement stack) throws IOException {
        Optional<Index> index = this.findIndex(stack);
        if (!index.isPresent()) {
            return;
        }
        Optional<IndexRegion> region = this.findRegion(stack, index.get());
        if (!region.isPresent() || !this.printedRegions.add(new AbstractMap.SimpleEntry<Index, IndexRegion>(index.get(), region.get()))) {
            return;
        }
        this.snippets.put(stack, this.printRegion(stack, index.get(), region.get()));
    }

    private Optional<Index> findIndex(StackTraceElement stack) {
        return this.indexes.computeIfAbsent(Index.relativePath(stack), key -> {
            try {
                return Index.read(stack);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Optional<IndexRegion> findRegion(StackTraceElement stack, Index index) {
        return index.regions().stream().filter(e -> (long)stack.getLineNumber() >= e.startLineNum()).filter(e -> (long)stack.getLineNumber() <= e.endLineNum()).sorted(Comparator.comparing(IndexRegion::lineCount)).reduce((a, b) -> a.lineCount() <= 1L ? b : a);
    }

    private String printRegion(StackTraceElement stack, Index index, IndexRegion region) throws IOException {
        StringBuilder out = new StringBuilder();
        int width = String.valueOf(region.endLineNum()).length();
        long lineNumber = region.startLineNum();
        for (String line : region.lines(index.source())) {
            out.append("\t");
            out.append(lineNumber == (long)stack.getLineNumber() ? "-> " : "   ");
            out.append(String.format("%" + width + "d", lineNumber));
            out.append("  ");
            out.append(line);
            out.append(System.lineSeparator());
            ++lineNumber;
        }
        return out.toString();
    }
}

