/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import stack.source.internal.SourceScanner;
import stack.source.internal.Throwables;

public final class SourceProcessor
extends AbstractProcessor {
    private final Set<CompilationUnitTree> units = new HashSet<CompilationUnitTree>();
    private SourceScanner scanner;
    private Trees trees;
    private boolean enabled = true;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment process) {
        super.init(process);
        this.scanner = new SourceScanner(process);
        try {
            this.trees = Trees.instance(process);
        }
        catch (IllegalArgumentException e) {
            this.enabled = false;
            Messager messager = process.getMessager();
            messager.printMessage(Diagnostic.Kind.WARNING, this.getClass().getName() + ": Current processing environment '" + process + "' is not supported by the Java Compiler Tree API, no stack trace will be decorated.");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (!this.enabled) {
            return false;
        }
        try {
            this.doProcess(round);
        }
        catch (Throwable e) {
            this.logWarning(e);
        }
        return false;
    }

    private void doProcess(RoundEnvironment round) {
        this.collectCompilationUnits(round);
        if (round.processingOver()) {
            this.processCompilationUnits();
        }
    }

    private void collectCompilationUnits(RoundEnvironment roundEnv) {
        roundEnv.getRootElements().stream().map(this.trees::getPath).map(TreePath::getCompilationUnit).forEach(this.units::add);
    }

    private void processCompilationUnits() {
        for (CompilationUnitTree unit : this.units) {
            this.scanner.scan(unit, this.trees);
        }
        this.units.clear();
    }

    private void logWarning(Throwable e) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, Throwables.getStackTraceAsString(e));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

