/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import stack.source.internal.Index;
import stack.source.internal.IndexRegion;

public final class Decorator {
    private static final String CAUSE_BY = "Caused by: ";
    private static final String SUPPRESSED = "Suppressed: ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Throwable throwable;
    private final boolean decorate;
    private final Map<String, Index> positiveCache = new HashMap<String, Index>();
    private final Set<String> negativeCache = new HashSet<String>();
    private final Set<Throwable> seen = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Map.Entry<Index, IndexRegion>> printedRegions = new HashSet<Map.Entry<Index, IndexRegion>>();

    public Decorator(Throwable throwable) {
        this(throwable, true);
    }

    Decorator(Throwable throwable, boolean decorate) {
        this.throwable = Objects.requireNonNull(throwable);
        this.decorate = decorate;
    }

    public String print() throws IOException {
        StringBuilder builder = new StringBuilder();
        this.print(builder);
        return builder.toString();
    }

    public void print(Appendable out) throws IOException {
        this.seen.add(this.throwable);
        out.append(String.valueOf(this.throwable));
        out.append(LINE_SEPARATOR);
        StackTraceElement[] trace = this.throwable.getStackTrace();
        for (StackTraceElement stackTraceElement : trace) {
            out.append("\tat ");
            this.print(stackTraceElement, out);
            out.append(LINE_SEPARATOR);
        }
        for (Serializable serializable : this.throwable.getSuppressed()) {
            this.print((Throwable)serializable, out, trace, SUPPRESSED, "\t");
        }
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            this.print(cause, out, trace, CAUSE_BY, "");
        }
    }

    private void print(Throwable e, Appendable out, StackTraceElement[] enclosingTrace, String caption, String prefix) throws IOException {
        if (!this.seen.add(e)) {
            this.printCircular(e, out);
            return;
        }
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        out.append(prefix);
        out.append(caption);
        out.append(String.valueOf(e));
        out.append(LINE_SEPARATOR);
        for (int i = 0; i <= m; ++i) {
            out.append(prefix).append("\tat ");
            this.print(trace[i], out);
            out.append(LINE_SEPARATOR);
        }
        if (framesInCommon != 0) {
            this.printCommonFrames(out, prefix, framesInCommon);
        }
        for (Throwable se : e.getSuppressed()) {
            this.print(se, out, trace, SUPPRESSED, prefix + "\t");
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            this.print(cause, out, trace, CAUSE_BY, prefix);
        }
    }

    private void printCircular(Throwable e, Appendable out) throws IOException {
        out.append("\t[CIRCULAR REFERENCE:");
        out.append(String.valueOf(e));
        out.append("]");
        out.append(LINE_SEPARATOR);
    }

    private void printCommonFrames(Appendable out, String prefix, int count) throws IOException {
        out.append(prefix);
        out.append("\t... ");
        out.append(String.valueOf(count));
        out.append(" more");
        out.append(LINE_SEPARATOR);
    }

    private void print(StackTraceElement element, Appendable out) throws IOException {
        out.append(element.toString());
        if (!this.decorate) {
            return;
        }
        Index index = this.findIndex(element);
        if (index == null) {
            return;
        }
        Optional<IndexRegion> region = index.regions().stream().filter(e -> (long)element.getLineNumber() >= e.startLineNum()).filter(e -> (long)element.getLineNumber() <= e.endLineNum()).sorted(Comparator.comparing(IndexRegion::lineCount)).reduce((a, b) -> b.lineCount() <= 6L ? b : a);
        if (region.isPresent()) {
            this.print(element, out, index, region.get());
        }
    }

    private void print(StackTraceElement element, Appendable out, Index index, IndexRegion region) throws IOException {
        if (!this.printedRegions.add(new AbstractMap.SimpleImmutableEntry<Index, IndexRegion>(index, region))) {
            return;
        }
        List<String> lines = region.lines(index.source());
        if (lines.isEmpty()) {
            return;
        }
        int width = String.valueOf(region.endLineNum()).length();
        out.append(LINE_SEPARATOR);
        out.append(LINE_SEPARATOR);
        long lineNumber = region.startLineNum();
        for (String line : lines) {
            out.append("\t");
            out.append(lineNumber == (long)element.getLineNumber() ? "-> " : "   ");
            out.append(String.format("%" + width + "d", lineNumber));
            out.append("  ");
            out.append(line);
            out.append(LINE_SEPARATOR);
            ++lineNumber;
        }
        out.append(LINE_SEPARATOR);
    }

    private Index findIndex(StackTraceElement element) throws IOException {
        String key = Index.relativePath(element);
        if (this.negativeCache.contains(key)) {
            return null;
        }
        Index index = this.positiveCache.get(key);
        if (index == null) {
            Optional<Index> read = Index.read(element);
            if (!read.isPresent()) {
                this.negativeCache.add(key);
                return null;
            }
            index = read.get();
            this.positiveCache.put(key, index);
        }
        return index;
    }
}

