/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.google.auto.value.AutoValue;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import stack.source.internal.AutoValue_Index;
import stack.source.internal.IndexRegion;

@AutoValue
abstract class Index {
    private static final byte VERSION = 2;

    Index() {
    }

    static Index create(Path source, long sourceModTime, Set<IndexRegion> regions) {
        return new AutoValue_Index(source.toAbsolutePath(), sourceModTime, Collections.unmodifiableSet(regions));
    }

    abstract Path source();

    abstract long sourceModTime();

    abstract Set<IndexRegion> regions();

    private static String relativePath(String pkgName, String fileName) {
        return Stream.of("stack-source", pkgName, fileName).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("/", "", ".index"));
    }

    private static String relativePath(StackTraceElement element) {
        String pkgName = Index.getPackageName(element);
        String fileName = element.getFileName();
        return Index.relativePath(pkgName, fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<Index> read(StackTraceElement element) {
        String resource = Index.relativePath(element);
        try (InputStream in = Index.class.getClassLoader().getResourceAsStream(resource);){
            if (in == null) {
                Optional<Index> optional = Optional.empty();
                return optional;
            }
            DataInputStream data = new DataInputStream(new GZIPInputStream(in));
            Optional<Index> optional = Index.read(data);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getPackageName(StackTraceElement element) {
        String className = element.getClassName();
        int pkgNameEnd = className.lastIndexOf(46);
        if (pkgNameEnd > 0) {
            return className.substring(0, pkgNameEnd);
        }
        return "";
    }

    private static Optional<Index> read(DataInput in) {
        try {
            if (in.readByte() != 2) {
                return Optional.empty();
            }
            Path source = Paths.get(in.readUTF(), new String[0]);
            long sourceModTime = in.readLong();
            int count = in.readInt();
            HashSet<IndexRegion> regions = new HashSet<IndexRegion>();
            for (int i = 0; i < count; ++i) {
                regions.add(IndexRegion.read(in));
            }
            return Optional.of(Index.create(source, sourceModTime, regions));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void write(ProcessingEnvironment env, FileObject src, String pkg) {
        try (DataOutputStream out = new DataOutputStream(new GZIPOutputStream(Index.createIndexFile(env, src, pkg).openOutputStream()));){
            this.write(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void write(DataOutput out) {
        try {
            out.writeByte(2);
            out.writeUTF(this.source().toString());
            out.writeLong(this.sourceModTime());
            out.writeInt(this.regions().size());
            for (IndexRegion element : this.regions()) {
                element.write(out);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static FileObject createIndexFile(ProcessingEnvironment env, FileObject unit, String pkg) {
        String name = new File(unit.getName()).getName();
        try {
            return env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", Index.relativePath(pkg, name), new Element[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

