/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.gdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.GoodDataException;
import com.gooddata.sdk.model.gdc.AboutLinks;
import java.util.List;

public class RootLinks
extends AboutLinks {
    public static final String URI = "/gdc";

    @JsonCreator
    public RootLinks(@JsonProperty(value="links") List<AboutLinks.Link> links) {
        super(null, null, null, links);
    }

    @JsonIgnore
    public String getHomeUri() {
        return this.getLink(LinkCategory.HOME).getUri();
    }

    @JsonIgnore
    public String getTokenUri() {
        return this.getLink(LinkCategory.TOKEN).getUri();
    }

    @JsonIgnore
    public String getLoginUri() {
        return this.getLink(LinkCategory.LOGIN).getUri();
    }

    @JsonIgnore
    public String getMetadataUri() {
        return this.getLink(LinkCategory.METADATA).getUri();
    }

    @JsonIgnore
    public String getXTabUri() {
        return this.getLink(LinkCategory.XTAB).getUri();
    }

    @JsonIgnore
    public String getAvailableElementsUri() {
        return this.getLink(LinkCategory.AVAILABLE_ELEMENTS).getUri();
    }

    @JsonIgnore
    public String getReportExporterUri() {
        return this.getLink(LinkCategory.REPORT_EXPORTER).getUri();
    }

    @JsonIgnore
    public String getAccountUri() {
        return this.getLink(LinkCategory.ACCOUNT).getUri();
    }

    @JsonIgnore
    public String getProjectsUri() {
        return this.getLink(LinkCategory.PROJECTS).getUri();
    }

    @JsonIgnore
    public String getToolUri() {
        return this.getLink(LinkCategory.TOOL).getUri();
    }

    @JsonIgnore
    public String getTemplatesUri() {
        return this.getLink(LinkCategory.TEMPLATES).getUri();
    }

    @JsonIgnore
    public String getUserStagingUri() {
        return this.getLink(LinkCategory.USER_STAGING).getUri();
    }

    @JsonIgnore
    private AboutLinks.Link getLink(LinkCategory category) {
        for (AboutLinks.Link link : this.getLinks()) {
            if (!category.value.equals(link.getCategory())) continue;
            return link;
        }
        throw new GoodDataException("No link with such category found");
    }

    private static enum LinkCategory {
        HOME("home"),
        TOKEN("token"),
        LOGIN("login"),
        METADATA("md"),
        XTAB("xtab"),
        AVAILABLE_ELEMENTS("availablelements"),
        REPORT_EXPORTER("report-exporter"),
        ACCOUNT("account"),
        PROJECTS("projects"),
        TOOL("tool"),
        TEMPLATES("templates"),
        USER_STAGING("uploads");

        private final String value;

        private LinkCategory(String value) {
            this.value = value;
        }
    }
}

