/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.lcm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LcmEntity {
    private final String projectId;
    private final String projectTitle;
    private final String clientId;
    private final String segmentId;
    private final String dataProductId;
    private final Map<String, String> links;

    public LcmEntity(String projectId, String projectTitle, Map<String, String> links) {
        this(projectId, projectTitle, null, null, null, links);
    }

    @JsonCreator
    public LcmEntity(@JsonProperty(value="projectId") String projectId, @JsonProperty(value="projectTitle") String projectTitle, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="segmentId") String segmentId, @JsonProperty(value="dataProductId") String dataProductId, @JsonProperty(value="links") Map<String, String> links) {
        this.projectId = (String)Validate.notEmpty((CharSequence)projectId, (String)"projectId");
        this.projectTitle = (String)Validate.notNull((Object)projectTitle, (String)"projectTitle");
        this.clientId = clientId;
        this.segmentId = segmentId;
        this.dataProductId = dataProductId;
        this.links = (Map)Validate.notNull(links, (String)"links");
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectTitle() {
        return this.projectTitle;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public String getDataProductId() {
        return this.dataProductId;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getProjectUri() {
        return this.getLink("project");
    }

    @JsonIgnore
    public String getClientUri() {
        return this.getLink("client");
    }

    @JsonIgnore
    public String getSegmentUri() {
        return this.getLink("segment");
    }

    @JsonIgnore
    public String getDataProductUri() {
        return this.getLink("dataProduct");
    }

    private String getLink(String link) {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(link);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LcmEntity lcmEntity = (LcmEntity)o;
        return Objects.equals(this.projectId, lcmEntity.projectId) && Objects.equals(this.projectTitle, lcmEntity.projectTitle) && Objects.equals(this.clientId, lcmEntity.clientId) && Objects.equals(this.segmentId, lcmEntity.segmentId) && Objects.equals(this.dataProductId, lcmEntity.dataProductId) && Objects.equals(this.links, lcmEntity.links);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.projectTitle, this.clientId, this.segmentId, this.dataProductId, this.links);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    public static class LinkCategory {
        public static final String PROJECT = "project";
        public static final String CLIENT = "client";
        public static final String SEGMENT = "segment";
        public static final String DATA_PRODUCT = "dataProduct";
    }
}

