/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.util.Validate;
import java.io.Serializable;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="kpiAlert")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KpiAlert
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = 4771232690549128988L;
    private final Content content;

    public KpiAlert(String title, String kpiUri, String dashboardUri, double threshold, String triggerCondition, String filterContextUri) {
        this(new Meta(title), new Content((String)Validate.notEmpty((CharSequence)kpiUri, (String)"kpiUri"), (String)Validate.notEmpty((CharSequence)dashboardUri, (String)"dashboardUri"), threshold, false, (String)Validate.notEmpty((CharSequence)triggerCondition, (String)"triggerCondition"), filterContextUri));
    }

    @JsonCreator
    private KpiAlert(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    @JsonProperty
    private Content getContent() {
        return this.content;
    }

    @JsonIgnore
    public boolean wasTriggered() {
        return this.getContent().isTriggered();
    }

    @JsonIgnore
    public double getThreshold() {
        return this.getContent().getThreshold();
    }

    @JsonIgnore
    public String getFilterContextUri() {
        return this.getContent().getFilterContext();
    }

    @JsonIgnore
    public String getTriggerCondition() {
        return this.getContent().getWhenTriggered();
    }

    @JsonIgnore
    public String getDashboardUri() {
        return this.getContent().getDashboard();
    }

    @JsonIgnore
    public String getKpiUri() {
        return this.getContent().getKpi();
    }

    public KpiAlert withTriggeredState(boolean wasTriggered) {
        return new KpiAlert(this.meta, new Content(this.getKpiUri(), this.getDashboardUri(), this.getThreshold(), wasTriggered, this.getTriggerCondition(), this.getFilterContextUri()));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isTriggered;
        private final double threshold;
        private final String filterContext;
        private final String whenTriggered;
        private final String dashboard;
        private final String kpi;

        @JsonCreator
        private Content(@JsonProperty(value="kpi") String kpi, @JsonProperty(value="dashboard") String dashboard, @JsonProperty(value="threshold") double threshold, @JsonProperty(value="isTriggered") boolean isTriggered, @JsonProperty(value="whenTriggered") String whenTriggered, @JsonProperty(value="filterContext") String filterContext) {
            this.isTriggered = isTriggered;
            this.threshold = threshold;
            this.filterContext = filterContext;
            this.whenTriggered = whenTriggered;
            this.dashboard = dashboard;
            this.kpi = kpi;
        }

        @JsonProperty(value="isTriggered")
        public boolean isTriggered() {
            return this.isTriggered;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public String getFilterContext() {
            return this.filterContext;
        }

        public String getWhenTriggered() {
            return this.whenTriggered;
        }

        public String getDashboard() {
            return this.dashboard;
        }

        public String getKpi() {
            return this.kpi;
        }
    }
}

