/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Obj;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.sdk.model.md.report.ReportDefinition;
import com.gooddata.util.GoodDataToStringBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@JsonTypeName(value="report")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Report
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = 189440633045112981L;
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Report(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public Report(String title, ReportDefinition ... definitions) {
        this(new Meta(title), new Content(Arrays.asList(Report.uris((Obj[])definitions)), Collections.emptyList()));
    }

    @JsonIgnore
    public Collection<String> getDefinitions() {
        return this.content.getDefinitions();
    }

    @JsonIgnore
    public Collection<String> getDomains() {
        return this.content.getDomains();
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 3437452191500594445L;
        private final Collection<String> definitions;
        private final Collection<String> domains;

        @JsonCreator
        public Content(@JsonProperty(value="definitions") Collection<String> definitions, @JsonProperty(value="domains") Collection<String> domains) {
            this.definitions = definitions;
            this.domains = domains;
        }

        public Collection<String> getDefinitions() {
            return this.definitions;
        }

        public Collection<String> getDomains() {
            return this.domains;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

