/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.gooddata.util.Validate;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class TagsDeserializer
extends JsonDeserializer<Set<String>> {
    public Set<String> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode root = (JsonNode)jp.readValueAsTree();
        Validate.notNull((Object)root, (String)"jsonNode");
        if (root.isTextual()) {
            HashSet<String> tags = new HashSet<String>();
            try (Scanner scanner = new Scanner(root.textValue());){
                while (scanner.hasNext()) {
                    tags.add(scanner.next());
                }
            }
            return tags;
        }
        throw new JsonMappingException((Closeable)jp, "Unknown value of type: " + root.getNodeType(), jp.getCurrentLocation());
    }
}

