/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.sdk.model.executeafm.ObjQualifier;
import com.gooddata.sdk.model.executeafm.UriObjQualifier;
import com.gooddata.sdk.model.executeafm.afm.filter.DateFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.FilterItem;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Objects;

@JsonRootName(value="relativeDateFilter")
public class RelativeDateFilter
extends DateFilter {
    private static final long serialVersionUID = 7257627800833737063L;
    static final String NAME = "relativeDateFilter";
    private final String granularity;
    private final Integer from;
    private final Integer to;

    @JsonCreator
    public RelativeDateFilter(@JsonProperty(value="dataSet") ObjQualifier dataSet, @JsonProperty(value="granularity") String granularity, @JsonProperty(value="from") Integer from, @JsonProperty(value="to") Integer to) {
        super(dataSet);
        this.granularity = (String)Validate.notEmpty((CharSequence)granularity, (String)"granularity");
        this.from = from;
        this.to = to;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getTo() {
        return this.to;
    }

    @Override
    public FilterItem withObjUriQualifier(UriObjQualifier qualifier) {
        return new RelativeDateFilter(qualifier, this.granularity, this.from, this.to);
    }

    @Override
    @JsonIgnore
    public boolean isAllTimeSelected() {
        return this.getFrom() == null || this.getTo() == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeDateFilter that = (RelativeDateFilter)o;
        return super.equals(that) && Objects.equals(this.granularity, that.granularity) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.granularity, this.from, this.to, super.hashCode());
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

