/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

@JsonTypeName(value="projectDashboard")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectDashboard
extends AbstractObj
implements Queryable {
    private static final long serialVersionUID = 6791559547484536326L;
    private final Content content;

    private ProjectDashboard(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = (Content)Validate.notNull((Object)content, (String)"content");
    }

    public ProjectDashboard(String title, Tab ... tabs) {
        this(new Meta(title), new Content(Arrays.asList(tabs)));
    }

    @JsonIgnore
    public Collection<Tab> getTabs() {
        return this.content.tabs;
    }

    @JsonIgnore
    public Tab getTabByName(String name) {
        for (Tab tab : this.getTabs()) {
            if (!Objects.equals(tab.title, name)) continue;
            return tab;
        }
        return null;
    }

    public Content getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Tab
    implements Serializable {
        private static final long serialVersionUID = 4755791353382871571L;
        private final String identifier;
        private final String title;
        @JsonProperty(value="items")
        private final Collection<Object> items = Collections.emptyList();

        @JsonCreator
        private Tab(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="title") String title) {
            this.identifier = identifier;
            this.title = title;
        }

        public Tab(String title) {
            this(null, title);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content
    implements Serializable {
        private static final long serialVersionUID = -3540410868419025134L;
        private final Collection<Tab> tabs;
        @JsonProperty(value="filters")
        private final Collection<Object> filters = Collections.emptyList();

        @JsonCreator
        private Content(@JsonProperty(value="tabs") Collection<Tab> tabs) {
            this.tabs = tabs;
        }

        public Collection<Tab> getTabs() {
            return this.tabs;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

