/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.maintenance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

@JsonTypeName(value="partialMDExport")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PartialMdExport {
    public static final String URI = "/gdc/md/{projectId}/maintenance/partialmdexport";
    private final Collection<String> uris;
    private final boolean crossDataCenterExport;
    private final boolean exportAttributeProperties;

    public PartialMdExport(String ... mdObjectsUris) {
        this(new HashSet<String>(Arrays.asList(mdObjectsUris)));
    }

    public PartialMdExport(Collection<String> mdObjectsUris) {
        this(false, false, mdObjectsUris);
    }

    public PartialMdExport(boolean exportAttributeProperties, boolean crossDataCenterExport, String ... mdObjectsUris) {
        this(exportAttributeProperties, crossDataCenterExport, new HashSet<String>(Arrays.asList(mdObjectsUris)));
    }

    public PartialMdExport(boolean exportAttributeProperties, boolean crossDataCenterExport, Collection<String> mdObjectsUris) {
        Validate.notEmpty(mdObjectsUris, (String)"uris");
        this.uris = mdObjectsUris;
        this.crossDataCenterExport = crossDataCenterExport;
        this.exportAttributeProperties = exportAttributeProperties;
    }

    public Collection<String> getUris() {
        return this.uris;
    }

    public boolean isCrossDataCenterExport() {
        return this.crossDataCenterExport;
    }

    public boolean isExportAttributeProperties() {
        return this.exportAttributeProperties;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

