/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataload.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.dataload.processes.DataloadProcess;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="execution")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessExecution {
    private final String executionsUri;
    private final String executable;
    private final Map<String, String> params;
    private final Map<String, String> hiddenParams;

    public ProcessExecution(DataloadProcess process, String executable) {
        this(process, executable, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public ProcessExecution(DataloadProcess process, String executable, Map<String, String> params) {
        this(process, executable, params, new HashMap<String, String>());
    }

    public ProcessExecution(DataloadProcess process, String executable, Map<String, String> params, Map<String, String> hiddenParams) {
        Validate.notNull((Object)process, (String)"process");
        this.executionsUri = (String)Validate.notEmpty((CharSequence)process.getExecutionsUri(), (String)"process executions link");
        this.executable = executable;
        this.params = (Map)Validate.notNull(params, (String)"params");
        this.hiddenParams = (Map)Validate.notNull(hiddenParams, (String)"hiddenParams");
        process.validateExecutable(executable);
    }

    public String getExecutable() {
        return this.executable;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHiddenParams() {
        return this.hiddenParams;
    }

    @JsonIgnore
    public String getExecutionsUri() {
        return this.executionsUri;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[]{"hiddenParams", "executionsUri"});
    }
}

