/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.visualization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.sdk.model.md.visualization.VisualizationType;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="visualizationClass")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VisualizationClass
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = -72785788784079208L;
    static final String NAME = "visualizationClass";
    private Content content;

    private VisualizationClass(@JsonProperty(value="content") Content content, @JsonProperty(value="meta") Meta meta) {
        super(meta);
        this.content = (Content)Validate.notNull((Object)content);
    }

    @JsonIgnore
    public String getIcon() {
        return this.getContent().getIcon();
    }

    @JsonIgnore
    public String getIconSelected() {
        return this.getContent().getIconSelected();
    }

    @JsonIgnore
    public String getChecksum() {
        return this.getContent().getChecksum();
    }

    @JsonIgnore
    public Float getOrderIndex() {
        return this.getContent().getOrderIndex();
    }

    @JsonIgnore
    public String getUrl() {
        return this.getContent().getUrl();
    }

    @JsonIgnore
    public VisualizationType getVisualizationType() {
        VisualizationType visualizationType = VisualizationType.TABLE;
        String[] uriParts = this.getContent().getUrl().split(":");
        if (uriParts.length > 0 && this.isLocal()) {
            String derivedType = uriParts[uriParts.length - 1];
            visualizationType = VisualizationType.of(derivedType);
        }
        return visualizationType;
    }

    @JsonIgnore
    private boolean isLocal() {
        return this.getContent().getChecksum().equals("local");
    }

    private Content getContent() {
        return this.content;
    }

    private static class Content
    implements Serializable {
        private final String url;
        private final String icon;
        private final String iconSelected;
        private final String checksum;
        private final Float orderIndex;

        @JsonCreator
        private Content(@JsonProperty(value="url") String url, @JsonProperty(value="icon") String icon, @JsonProperty(value="iconSelected") String iconSelected, @JsonProperty(value="checksum") String checksum, @JsonProperty(value="orderIndex") Float orderIndex) {
            this.url = (String)Validate.notNull((Object)url);
            this.icon = (String)Validate.notNull((Object)icon);
            this.iconSelected = (String)Validate.notNull((Object)iconSelected);
            this.checksum = (String)Validate.notNull((Object)checksum);
            this.orderIndex = orderIndex;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getIconSelected() {
            return this.iconSelected;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public Float getOrderIndex() {
            return this.orderIndex;
        }
    }
}

