/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.gooddata.sdk.common.util.Validate;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum RangeConditionOperator {
    BETWEEN,
    NOT_BETWEEN;


    @JsonValue
    public String toString() {
        return this.name();
    }

    @JsonCreator
    public static RangeConditionOperator of(String operator) {
        Validate.notNull((Object)operator, (String)"operator");
        try {
            return RangeConditionOperator.valueOf(operator);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unknown value for range condition operator: \"%s\", supported values are: [%s]", operator, Arrays.stream(RangeConditionOperator.values()).map(Enum::name).collect(Collectors.joining(","))), e);
        }
    }
}

