/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.ISOZonedDateTime;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.project.Environment;
import com.gooddata.sdk.model.util.UriHelper;
import java.time.ZonedDateTime;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="instance")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Warehouse {
    private static final String ID_PARAM = "id";
    public static final String URI = "/gdc/datawarehouse/instances/{id}";
    private static final String SELF_LINK = "self";
    private static final String STATUS_ENABLED = "ENABLED";
    private String title;
    private String description;
    private final String authorizationToken;
    @ISOZonedDateTime
    private ZonedDateTime created;
    @ISOZonedDateTime
    private ZonedDateTime updated;
    private String createdBy;
    private String updatedBy;
    private String status;
    private String environment;
    private Map<String, String> links;
    private String connectionUrl;
    private String license;

    public Warehouse(String title, String authToken) {
        this(title, authToken, null);
    }

    public Warehouse(String title, String authToken, String description) {
        this.title = (String)Validate.notNull((Object)title, (String)"title");
        this.authorizationToken = authToken;
        this.description = description;
    }

    public Warehouse(String title, String authToken, String description, ZonedDateTime created, ZonedDateTime updated, String createdBy, String updatedBy, String status, String environment, String connectionUrl, Map<String, String> links) {
        this(title, authToken, description);
        this.created = created;
        this.updated = updated;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.status = status;
        this.environment = environment;
        this.connectionUrl = connectionUrl;
        this.links = links;
    }

    @JsonCreator
    public Warehouse(@JsonProperty(value="title") String title, @JsonProperty(value="authorizationToken") String authToken, @JsonProperty(value="description") String description, @JsonProperty(value="created") ZonedDateTime created, @JsonProperty(value="updated") ZonedDateTime updated, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="updatedBy") String updatedBy, @JsonProperty(value="status") String status, @JsonProperty(value="environment") String environment, @JsonProperty(value="connectionUrl") String connectionUrl, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="license") String license) {
        this(title, authToken, description, created, updated, createdBy, updatedBy, status, environment, connectionUrl, links);
        this.license = license;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getDescription() {
        return this.description;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getStatus() {
        return this.status;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getLicense() {
        return this.license;
    }

    @JsonIgnore
    public void setEnvironment(Environment environment) {
        Validate.notNull((Object)((Object)environment), (String)"environment");
        this.setEnvironment(environment.name());
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getId() {
        return UriHelper.getLastUriPart(this.getUri());
    }

    @JsonIgnore
    public boolean isEnabled() {
        return STATUS_ENABLED.equals(this.status);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

