/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.md.IdentifierAndUri;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IdentifiersAndUris {
    public static final String URI = "/gdc/md/{projectId}/identifiers";
    private final List<IdentifierAndUri> identifiersAndUris;

    @JsonCreator
    IdentifiersAndUris(@JsonProperty(value="identifiers") List<IdentifierAndUri> identifiersAndUris) {
        this.identifiersAndUris = identifiersAndUris;
    }

    public List<String> getUris() {
        return this.identifiersAndUris.stream().map(IdentifierAndUri::getUri).collect(Collectors.toList());
    }

    @Deprecated
    public Map<String, String> asMap() {
        return this.asIdentifierToUri();
    }

    public Map<String, String> asIdentifierToUri() {
        if (this.identifiersAndUris == null) {
            return Collections.emptyMap();
        }
        Map<String, String> identifierToUri = this.identifiersAndUris.stream().collect(Collectors.toMap(IdentifierAndUri::getIdentifier, IdentifierAndUri::getUri));
        return Collections.unmodifiableMap(identifierToUri);
    }

    public Map<String, String> asUriToIdentifier() {
        if (this.identifiersAndUris == null) {
            return Collections.emptyMap();
        }
        Map<String, String> uriToIdentifier = this.identifiersAndUris.stream().collect(Collectors.toMap(IdentifierAndUri::getUri, IdentifierAndUri::getIdentifier));
        return Collections.unmodifiableMap(uriToIdentifier);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

