/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.gdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.gdc.GdcError;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import java.util.Collection;
import java.util.Collections;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="wTaskStatus")
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskStatus {
    private static final String OK = "OK";
    private static final String RUNNING = "RUNNING";
    private final String status;
    private final String pollUri;
    private final Collection<GdcError> messages;

    @JsonCreator
    private TaskStatus(@JsonProperty(value="status") String status, @JsonProperty(value="poll") String pollUri, @JsonProperty(value="messages") Collection<GdcError> messages) {
        this.status = status;
        this.pollUri = pollUri;
        this.messages = messages;
    }

    public TaskStatus(String status, String pollUri) {
        this(status, pollUri, Collections.emptyList());
    }

    public String getStatus() {
        return this.status;
    }

    public String getPollUri() {
        return this.pollUri;
    }

    public Collection<GdcError> getMessages() {
        return this.messages;
    }

    public boolean isSuccess() {
        return OK.equals(this.status);
    }

    public boolean isRunning() {
        return RUNNING.equals(this.status);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

