/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.gooddata.sdk.common.util.Validate;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ComparisonConditionOperator {
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL_TO,
    LESS_THAN,
    LESS_THAN_OR_EQUAL_TO,
    EQUAL_TO,
    NOT_EQUAL_TO;


    @JsonValue
    public String toString() {
        return this.name();
    }

    @JsonCreator
    public static ComparisonConditionOperator of(String operator) {
        Validate.notNull((Object)operator, (String)"operator");
        try {
            return ComparisonConditionOperator.valueOf(operator);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unknown value for comparison condition operator: \"%s\", supported values are: [%s]", operator, Arrays.stream(ComparisonConditionOperator.values()).map(Enum::name).collect(Collectors.joining(","))), e);
        }
    }
}

