/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.hierarchicalconfig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.hierarchicalconfig.ConfigItem;
import com.gooddata.sdk.model.hierarchicalconfig.SourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="settings")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigItems
implements Iterable<ConfigItem> {
    public static final String CLIENT_CONFIG_ITEMS_URI = SourceType.CLIENT.getApiUri();
    public static final String DATA_PRODUCT_CONFIG_ITEMS_URI = SourceType.DATA_PRODUCT.getApiUri();
    public static final String SEGMENT_CONFIG_ITEMS_URI = SourceType.SEGMENT.getApiUri();
    public static final String DOMAIN_CONFIG_ITEMS_URI = SourceType.DOMAIN.getApiUri();
    public static final String PROJECT_CONFIG_ITEMS_URI = SourceType.PROJECT.getApiUri();
    public static final String PROJECT_GROUP_CONFIG_ITEMS_URI = SourceType.PROJECT_GROUP.getApiUri();
    @JsonProperty(value="items")
    private final List<ConfigItem> items = new ArrayList<ConfigItem>();

    @JsonCreator
    public ConfigItems(@JsonProperty(value="items") List<ConfigItem> items) {
        if (items != null && !items.isEmpty()) {
            this.items.addAll(items);
        }
    }

    @Override
    public Iterator<ConfigItem> iterator() {
        return this.items.iterator();
    }

    public String getValue(String configName) {
        Validate.notEmpty((CharSequence)configName, (String)"configName");
        for (ConfigItem item : this.items) {
            if (!configName.equalsIgnoreCase(item.getKey())) continue;
            return item.getValue();
        }
        return null;
    }

    public boolean isEnabled(String configName) {
        Validate.notEmpty((CharSequence)configName, (String)"configName");
        for (ConfigItem item : this.items) {
            if (!configName.equalsIgnoreCase(item.getKey())) continue;
            return Boolean.parseBoolean(item.getValue());
        }
        return false;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

