/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.sdk.common.util.BooleanDeserializer;
import com.gooddata.sdk.common.util.BooleanIntegerSerializer;
import com.gooddata.sdk.common.util.BooleanStringSerializer;
import com.gooddata.sdk.common.util.GDZonedDateTime;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.util.TagsDeserializer;
import com.gooddata.sdk.model.util.TagsSerializer;
import com.gooddata.sdk.model.util.UriHelper;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Meta
implements Serializable {
    private static final long serialVersionUID = -8102041850487115166L;
    private static final int SUMMARY_MAX_LENGTH = 2048;
    private static final int TITLE_MAX_LENGTH = 255;
    private String author;
    private String contributor;
    @GDZonedDateTime
    private ZonedDateTime created;
    @GDZonedDateTime
    private ZonedDateTime updated;
    private String summary;
    private String title;
    private String category;
    private Set<String> tags;
    private String uri;
    private String identifier;
    private Boolean deprecated;
    private Boolean production;
    private Boolean locked;
    private Boolean unlisted;
    private Boolean sharedWithSomeone;
    private Set<String> flags;

    @JsonCreator
    protected Meta(@JsonProperty(value="author") String author, @JsonProperty(value="contributor") String contributor, @JsonProperty(value="created") ZonedDateTime created, @JsonProperty(value="updated") ZonedDateTime updated, @JsonProperty(value="summary") String summary, @JsonProperty(value="title") String title, @JsonProperty(value="category") String category, @JsonProperty(value="tags") @JsonDeserialize(using=TagsDeserializer.class) Set<String> tags, @JsonProperty(value="uri") String uri, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="flags") Set<String> flags) {
        this.author = author;
        this.uri = uri;
        this.tags = tags;
        this.created = created;
        this.summary = StringUtils.substring((String)summary, (int)0, (int)2048);
        this.title = StringUtils.substring((String)title, (int)0, (int)255);
        this.updated = updated;
        this.category = category;
        this.identifier = identifier;
        this.contributor = contributor;
        this.flags = flags;
    }

    public Meta(String author, String contributor, ZonedDateTime created, ZonedDateTime updated, String summary, String title, String category, Set<String> tags, String uri, String identifier, Boolean deprecated, Boolean production, Boolean locked, Boolean unlisted, Boolean sharedWithSomeone, Set<String> flags) {
        this.author = author;
        this.contributor = contributor;
        this.created = created;
        this.updated = updated;
        this.summary = summary;
        this.title = title;
        this.category = category;
        this.tags = tags;
        this.uri = uri;
        this.identifier = identifier;
        this.deprecated = deprecated;
        this.production = production;
        this.locked = locked;
        this.unlisted = unlisted;
        this.sharedWithSomeone = sharedWithSomeone;
        this.flags = flags;
    }

    public Meta(String title) {
        this(title, null);
    }

    public Meta(String title, String summary) {
        this.title = title;
        this.summary = summary;
    }

    @JsonIgnore
    public String getId() {
        return UriHelper.getLastUriPart(this.getUri());
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContributor() {
        return this.contributor;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @JsonSerialize(using=TagsSerializer.class)
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="deprecated")
    @JsonSerialize(using=BooleanStringSerializer.class)
    public Boolean isDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    @JsonDeserialize(using=BooleanDeserializer.class)
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="isProduction")
    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean isProduction() {
        return this.production;
    }

    @JsonProperty(value="isProduction")
    @JsonDeserialize(using=BooleanDeserializer.class)
    public void setProduction(Boolean production) {
        this.production = production;
    }

    @JsonProperty(value="locked")
    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean isLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonDeserialize(using=BooleanDeserializer.class)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @JsonProperty(value="unlisted")
    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean isUnlisted() {
        return this.unlisted;
    }

    @JsonProperty(value="unlisted")
    @JsonDeserialize(using=BooleanDeserializer.class)
    public void setUnlisted(Boolean unlisted) {
        this.unlisted = unlisted;
    }

    @JsonProperty(value="sharedWithSomeone")
    @JsonSerialize(using=BooleanIntegerSerializer.class)
    public Boolean isSharedWithSomeone() {
        return this.sharedWithSomeone;
    }

    @JsonProperty(value="sharedWithSomeone")
    @JsonDeserialize(using=BooleanDeserializer.class)
    public void setSharedWithSomeone(Boolean sharedWithSomeone) {
        this.sharedWithSomeone = sharedWithSomeone;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<String> flags) {
        this.flags = flags;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

