/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.hierarchicalconfig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.hierarchicalconfig.SourceType;

@JsonTypeName(value="settingItem")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConfigItem {
    public static final String CLIENT_CONFIG_ITEM_URI = SourceType.CLIENT.getApiUri() + "/{configName}";
    public static final String DATA_PRODUCT_CONFIG_ITEM_URI = SourceType.DATA_PRODUCT.getApiUri() + "/{configName}";
    public static final String SEGMENT_CONFIG_ITEM_URI = SourceType.SEGMENT.getApiUri() + "/{configName}";
    public static final String DOMAIN_CONFIG_ITEM_URI = SourceType.DOMAIN.getApiUri() + "/{configName}";
    public static final String PROJECT_CONFIG_ITEM_URI = SourceType.PROJECT.getApiUri() + "/{configName}";
    public static final String PROJECT_GROUP_CONFIG_ITEM_URI = SourceType.PROJECT_GROUP.getApiUri() + "/{configName}";
    private final String key;
    private String value;
    private final String source;
    private final Links links;

    public ConfigItem(String key, String value) {
        this((String)Validate.notEmpty((CharSequence)key, (String)"key"), (String)Validate.notEmpty((CharSequence)value, (String)"value"), null, null);
    }

    @JsonCreator
    ConfigItem(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="source") String source, @JsonProperty(value="links") Links links) {
        this.key = key;
        this.value = value;
        this.source = source;
        this.links = links;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public String getName() {
        return this.key;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Links getLinks() {
        return this.links;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return Boolean.parseBoolean(this.value);
    }

    public void setEnabled(Boolean value) {
        this.value = String.valueOf(value);
    }

    @JsonIgnore
    public SourceType getSourceType() {
        return SourceType.get(this.source);
    }

    @JsonIgnore
    public String getUri() {
        return ((Links)Validate.notNullState((Object)this.links, (String)"links")).getSelf();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigItem that = (ConfigItem)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Links {
        private final String self;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self) {
            this.self = self;
        }

        public String getSelf() {
            return this.self;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

