/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.util.UriHelper;
import java.util.List;

@JsonTypeName(value="accountSetting")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Account {
    public static final String URI = "/gdc/account/profile/{id}";
    public static final String ACCOUNTS_URI = "/gdc/account/domains/{organization_name}/users";
    public static final String ACCOUNT_BY_EMAIL_URI = "/gdc/account/domains/{organization_name}/users?login={email}";
    public static final String LOGIN_URI = "/gdc/account/login/{id}";
    public static final String CURRENT_ID = "current";
    private final String login;
    @JsonView(value={UpdateView.class})
    private String email;
    @JsonView(value={UpdateView.class})
    private String password;
    @JsonView(value={UpdateView.class})
    private String verifyPassword;
    @JsonView(value={UpdateView.class})
    private String firstName;
    @JsonView(value={UpdateView.class})
    private String lastName;
    @JsonView(value={UpdateView.class})
    private List<String> ipWhitelist;
    @JsonView(value={UpdateView.class})
    private List<String> authenticationModes;
    @JsonIgnore
    private final Links links;

    @JsonCreator
    private Account(@JsonProperty(value="login") String login, @JsonProperty(value="email") String email, @JsonProperty(value="password") String password, @JsonProperty(value="verifyPassword") String verifyPassword, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="ipWhitelist") List<String> ipWhitelist, @JsonProperty(value="authenticationModes") List<String> authenticationModes, @JsonProperty(value="links") Links links) {
        this.login = login;
        this.email = email;
        this.password = password;
        this.verifyPassword = verifyPassword;
        this.firstName = firstName;
        this.lastName = lastName;
        this.ipWhitelist = ipWhitelist;
        this.authenticationModes = authenticationModes;
        this.links = links;
    }

    public Account(String login, String email, String password, String firstName, String lastName, List<String> ipWhitelist, List<String> authenticationModes) {
        this(login, email, password, password, firstName, lastName, ipWhitelist, authenticationModes, null);
    }

    public Account(String firstName, String lastName, Links links) {
        this(null, null, null, null, firstName, lastName, null, null, links);
    }

    public Account(String email, String password, String firstName, String lastName) {
        this(email, email, password, password, firstName, lastName, null, null, null);
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVerifyPassword() {
        return this.verifyPassword;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String getUri() {
        return this.links.getSelf();
    }

    @JsonIgnore
    public String getProjectsUri() {
        return this.links.getProjects();
    }

    @JsonIgnore
    public String getId() {
        return Account.getId(this.getUri());
    }

    public List<String> getIpWhitelist() {
        return this.ipWhitelist;
    }

    public List<String> getAuthenticationModes() {
        return this.authenticationModes;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerifyPassword(String verifyPassword) {
        this.verifyPassword = verifyPassword;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setIpWhitelist(List<String> ipWhitelist) {
        this.ipWhitelist = ipWhitelist;
    }

    public void setAuthenticationModes(List<String> authenticationModes) {
        this.authenticationModes = authenticationModes;
    }

    public static String getId(String uri) {
        return UriHelper.getLastUriPart(uri);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[]{"password", "verifyPassword"});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Links {
        private final String self;
        private final String projects;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self, @JsonProperty(value="projects") String projects) {
            this.self = self;
            this.projects = projects;
        }

        public String getSelf() {
            return this.self;
        }

        public String getProjects() {
            return this.projects;
        }
    }

    public static enum AuthenticationMode {
        PASSWORD,
        SSO;

    }

    public static class UpdateView {
    }
}

