/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.MaqlAst;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.Updatable;
import java.io.Serializable;
import java.util.Collection;

@JsonTypeName(value="metric")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"links"})
public class Metric
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = -1666713447809179661L;
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Metric(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public Metric(String title, String expression, String format) {
        this(new Meta(title), new Content(expression, format));
    }

    @JsonIgnore
    public String getExpression() {
        return this.content.getExpression();
    }

    @JsonIgnore
    public String getFormat() {
        return this.content.getFormat();
    }

    @JsonIgnore
    public MaqlAst getMaqlAst() {
        return this.content.getMaqlAst();
    }

    @JsonIgnore
    public Collection<String> getFolders() {
        return this.content.getFolders();
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 7959588028233637749L;
        private final String expression;
        private final Collection<String> folders;
        @JsonProperty(value="format")
        private String format;
        @JsonProperty(value="tree")
        private MaqlAst maqlAst;

        @JsonCreator
        public Content(@JsonProperty(value="expression") String expression, @JsonProperty(value="folders") Collection<String> folders) {
            this.expression = expression;
            this.folders = folders;
        }

        public Content(String expression, String format) {
            this.expression = expression;
            this.format = format;
            this.folders = null;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public MaqlAst getMaqlAst() {
            return this.maqlAst;
        }

        public void setMaqlAst(MaqlAst maqlAst) {
            this.maqlAst = maqlAst;
        }

        public Collection<String> getFolders() {
            return this.folders;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

