/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageableList;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.Warehouse;
import com.gooddata.warehouse.WarehouseNotFoundException;
import com.gooddata.warehouse.WarehouseTask;
import com.gooddata.warehouse.WarehouseUser;
import com.gooddata.warehouse.WarehouseUsers;
import com.gooddata.warehouse.Warehouses;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class WarehouseService
extends AbstractService {
    private final String warehouseHost;
    private final int warehousePort;

    public WarehouseService(RestTemplate restTemplate, String warehouseHost, int warehousePort) {
        super(restTemplate);
        this.warehouseHost = Validate.notNull(warehouseHost, "warehouseHost");
        this.warehousePort = warehousePort;
    }

    public FutureResult<Warehouse> createWarehouse(Warehouse warehouse) {
        WarehouseTask task;
        Validate.notNull(warehouse, "warehouse");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances", (Object)warehouse, WarehouseTask.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create Warehouse", e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when Warehouse POSTed to API");
        }
        return new PollResult<Warehouse>(this, new AbstractPollHandler<WarehouseTask, Warehouse>(task.getPollLink(), WarehouseTask.class, Warehouse.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            protected void onFinish() {
                if (!((Warehouse)this.getResult()).isEnabled()) {
                    throw new GoodDataException("Created warehouse, uri: " + ((Warehouse)this.getResult()).getUri() + " is not enabled!");
                }
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    Warehouse warehouse = (Warehouse)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseLink(), Warehouse.class, new Object[0]);
                    this.setResult(WarehouseService.this.setWarehouseConnection(warehouse));
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("Warehouse creation finished, but can't get created warehouse, uri: " + pollResult.getWarehouseLink(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to create warehouse", e);
            }
        });
    }

    public void removeWarehouse(Warehouse warehouse) {
        Validate.notNull(warehouse, "warehouse");
        try {
            this.restTemplate.delete(warehouse.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to delete Warehouse, uri: " + warehouse.getUri(), e);
        }
    }

    public Warehouse getWarehouseByUri(String uri) {
        Validate.notEmpty(uri, "uri");
        try {
            return this.setWarehouseConnection((Warehouse)this.restTemplate.getForObject(uri, Warehouse.class, new Object[0]));
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get Warehouse instance " + uri, e);
        }
    }

    public Warehouse getWarehouseById(String id) {
        Validate.notEmpty(id, "id");
        return this.getWarehouseByUri(WarehouseService.uriFromId(id));
    }

    private static String uriFromId(String id) {
        return Warehouse.TEMPLATE.expand(new Object[]{id}).toString();
    }

    public PageableList<Warehouse> listWarehouses() {
        return this.listWarehouses(URI.create("/gdc/datawarehouse/instances"));
    }

    public PageableList<Warehouse> listWarehouses(Page page) {
        Validate.notNull(page, "page");
        return this.listWarehouses(page.getPageUri(UriComponentsBuilder.fromUriString((String)"/gdc/datawarehouse/instances")));
    }

    private PageableList<Warehouse> listWarehouses(URI uri) {
        try {
            Warehouses result = (Warehouses)this.restTemplate.getForObject(uri, Warehouses.class);
            if (result == null) {
                return new PageableList<Warehouse>();
            }
            return this.setWarehouseConnection(result);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list Warehouses", e);
        }
    }

    public PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse, Page page) {
        Validate.notNull(warehouse, "warehouse");
        Validate.notNull(warehouse.getId(), "warehouse.id");
        Validate.notNull(page, "page");
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)WarehouseUsers.TEMPLATE.expand(new Object[]{warehouse.getId()}));
            URI uri = page.getPageUri(builder);
            WarehouseUsers result = (WarehouseUsers)this.restTemplate.getForObject(uri, WarehouseUsers.class);
            return result != null ? result : new PageableList();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list users of warehouse " + warehouse.getId(), e);
        }
    }

    public FutureResult<WarehouseUser> addUserToWarehouse(Warehouse warehouse, WarehouseUser user) {
        WarehouseTask task;
        Validate.notNull(user, "user");
        Validate.notNull(warehouse, "warehouse");
        Validate.notNull(warehouse.getId(), "warehouse.id");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances/{id}/users", (Object)user, WarehouseTask.class, new Object[]{warehouse.getId()});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable add user to warehouse " + warehouse.getId(), e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when user POSTed to API");
        }
        return new PollResult<WarehouseUser>(this, new AbstractPollHandler<WarehouseTask, WarehouseUser>(task.getPollLink(), WarehouseTask.class, WarehouseUser.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    WarehouseUser newUser = (WarehouseUser)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseUserLink(), WarehouseUser.class, new Object[0]);
                    this.setResult(newUser);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("User added to warehouse, but can't get it back, uri: " + pollResult.getWarehouseUserLink(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to add user to warehouse", e);
            }
        });
    }

    public Warehouse updateWarehouse(Warehouse toUpdate) {
        Validate.notNull(toUpdate, "warehouse to update");
        try {
            this.restTemplate.put(toUpdate.getUri(), (Object)toUpdate, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to update Warehouse, uri: " + toUpdate.getUri());
        }
        return this.getWarehouseByUri(toUpdate.getUri());
    }

    private Warehouse setWarehouseConnection(Warehouse warehouse) {
        Validate.notNull(warehouse, "warehouse");
        warehouse.setWarehouseHost(this.warehouseHost);
        warehouse.setWarehousePort(this.warehousePort);
        return warehouse;
    }

    private PageableList<Warehouse> setWarehouseConnection(PageableList<Warehouse> warehouses) {
        Validate.notNull(warehouses, "warehouses");
        for (Warehouse warehouse : warehouses) {
            this.setWarehouseConnection(warehouse);
        }
        return warehouses;
    }
}

