/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.connector.ConnectorType;
import com.gooddata.connector.Settings;
import com.gooddata.util.Validate;

public class Zendesk4Settings
implements Settings {
    private String apiUrl;
    private final String type;
    private final String syncTime;
    private final String syncTimeZone;

    public Zendesk4Settings(String apiUrl) {
        this(apiUrl, null, null, null);
    }

    @JsonCreator
    public Zendesk4Settings(@JsonProperty(value="apiUrl") String apiUrl, @JsonProperty(value="type") String type, @JsonProperty(value="syncTime") String syncTime, @JsonProperty(value="syncTimeZone") String syncTimeZone) {
        this.apiUrl = Validate.notEmpty(apiUrl, "apiUrl");
        this.type = type;
        this.syncTime = syncTime;
        this.syncTimeZone = syncTimeZone;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = Validate.notEmpty(apiUrl, "apiUrl");
    }

    public String getType() {
        return this.type;
    }

    public String getSyncTime() {
        return this.syncTime;
    }

    public String getSyncTimeZone() {
        return this.syncTimeZone;
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.ZENDESK4;
    }

    public static enum Zendesk4Type {
        plus,
        enterprise;

    }
}

