/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.md.Meta;
import com.gooddata.md.report.AttributeInGrid;
import com.gooddata.md.report.Filter;
import com.gooddata.md.report.Grid;
import com.gooddata.md.report.GridElement;
import com.gooddata.md.report.ReportDefinition;
import com.gooddata.md.report.ReportDefinitionContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class OneNumberReportDefinitionContent
extends ReportDefinitionContent {
    public static final String FORMAT = "oneNumber";
    private final OneNumberVisualization oneNumber;

    @JsonCreator
    private OneNumberReportDefinitionContent(@JsonProperty(value="format") String format, @JsonProperty(value="grid") Grid grid, @JsonProperty(value="oneNumber") OneNumberVisualization oneNumber, @JsonProperty(value="filters") Collection<Filter> filters) {
        super(format, grid, filters);
        this.oneNumber = oneNumber;
    }

    OneNumberReportDefinitionContent(Grid grid, String description, Collection<Filter> filters) {
        super(FORMAT, grid, filters);
        this.oneNumber = new OneNumberVisualization(new OneNumberLabels(description));
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public OneNumberVisualization getOneNumber() {
        return this.oneNumber;
    }

    public static ReportDefinition create(String title, List<String> columns, List<AttributeInGrid> rows, List<GridElement> metrics) {
        return OneNumberReportDefinitionContent.create(title, columns, rows, metrics, Collections.emptyList());
    }

    public static ReportDefinition create(String title, List<String> columns, List<AttributeInGrid> rows, List<GridElement> metrics, Collection<Filter> filters) {
        return new ReportDefinition(new Meta(title), (ReportDefinitionContent)new OneNumberReportDefinitionContent(new Grid(columns, rows, metrics), title, filters));
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private static class OneNumberLabels {
        private final String description;

        @JsonCreator
        private OneNumberLabels(@JsonProperty(value="description") String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private static class OneNumberVisualization {
        private final OneNumberLabels labels;

        @JsonCreator
        private OneNumberVisualization(@JsonProperty(value="labels") OneNumberLabels labels) {
            this.labels = labels;
        }

        public OneNumberLabels getLabels() {
            return this.labels;
        }
    }
}

