/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.GoodDataSettings;
import com.gooddata.HeaderSettingRequestInterceptor;
import com.gooddata.UriPrefixingClientHttpRequestFactory;
import com.gooddata.account.AccountService;
import com.gooddata.connector.ConnectorService;
import com.gooddata.dataload.processes.ProcessService;
import com.gooddata.dataset.DatasetService;
import com.gooddata.gdc.DataStoreService;
import com.gooddata.gdc.GdcService;
import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.LoginSSTRetrievalStrategy;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.md.MetadataService;
import com.gooddata.md.maintenance.ExportImportService;
import com.gooddata.model.ModelService;
import com.gooddata.notification.NotificationService;
import com.gooddata.project.ProjectService;
import com.gooddata.report.ReportService;
import com.gooddata.util.ResponseErrorHandler;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.WarehouseService;
import java.util.Arrays;
import java.util.Collections;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.VersionInfo;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class GoodData {
    public static final String GDC_REQUEST_ID_HEADER = "X-GDC-REQUEST";
    protected static final String PROTOCOL = "https";
    protected static final int PORT = 443;
    protected static final String HOSTNAME = "secure.gooddata.com";
    private static final String UNKNOWN_VERSION = "UNKNOWN";
    private static final int RESTAPI_VERSION = 1;
    private final RestTemplate restTemplate;
    private final AccountService accountService;
    private final ProjectService projectService;
    private final MetadataService metadataService;
    private final ModelService modelService;
    private final GdcService gdcService;
    private final DataStoreService dataStoreService;
    private final DatasetService datasetService;
    private final ReportService reportService;
    private final ConnectorService connectorService;
    private final ProcessService processService;
    private final WarehouseService warehouseService;
    private final NotificationService notificationService;
    private final ExportImportService exportImportService;

    public GoodData(String login, String password) {
        this(HOSTNAME, login, password, new GoodDataSettings());
    }

    public GoodData(String login, String password, GoodDataSettings settings) {
        this(HOSTNAME, login, password, settings);
    }

    public GoodData(String hostname, String login, String password) {
        this(hostname, login, password, 443, PROTOCOL, new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, GoodDataSettings settings) {
        this(hostname, login, password, 443, PROTOCOL, settings);
    }

    public GoodData(String hostname, String login, String password, int port) {
        this(hostname, login, password, port, PROTOCOL, new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, int port, GoodDataSettings settings) {
        this(hostname, login, password, port, PROTOCOL, settings);
    }

    protected GoodData(String hostname, String login, String password, int port, String protocol, GoodDataSettings settings) {
        Validate.notEmpty(hostname, "hostname");
        Validate.notEmpty(login, "login");
        Validate.notEmpty(password, "password");
        Validate.notEmpty(protocol, "protocol");
        HttpClient httpClient = this.createHttpClient(login, password, hostname, port, protocol, this.createHttpClientBuilder(settings));
        this.restTemplate = this.createRestTemplate(hostname, httpClient, port, protocol);
        this.accountService = new AccountService(this.getRestTemplate());
        this.projectService = new ProjectService(this.getRestTemplate(), this.accountService);
        this.metadataService = new MetadataService(this.getRestTemplate());
        this.modelService = new ModelService(this.getRestTemplate());
        this.gdcService = new GdcService(this.getRestTemplate());
        this.dataStoreService = new DataStoreService(httpClient, this.getRestTemplate(), this.gdcService, new HttpHost(hostname, port, protocol).toURI());
        this.datasetService = new DatasetService(this.getRestTemplate(), this.dataStoreService);
        this.reportService = new ReportService(this.getRestTemplate());
        this.processService = new ProcessService(this.getRestTemplate(), this.accountService, this.dataStoreService);
        this.warehouseService = new WarehouseService(this.getRestTemplate());
        this.connectorService = new ConnectorService(this.getRestTemplate(), this.projectService);
        this.notificationService = new NotificationService(this.getRestTemplate());
        this.exportImportService = new ExportImportService(this.getRestTemplate());
    }

    private RestTemplate createRestTemplate(String hostname, HttpClient httpClient, int port, String protocol) {
        UriPrefixingClientHttpRequestFactory factory = new UriPrefixingClientHttpRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(httpClient), hostname, port, protocol);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        restTemplate.setInterceptors(Arrays.asList(new HeaderSettingRequestInterceptor(Collections.singletonMap("Accept", this.getAcceptHeaderValue()))));
        restTemplate.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)new ResponseErrorHandler(restTemplate.getMessageConverters()));
        return restTemplate;
    }

    private HttpClientBuilder createHttpClientBuilder(GoodDataSettings settings) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(settings.getMaxConnections());
        connectionManager.setMaxTotal(settings.getMaxConnections());
        RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        requestConfig.setConnectTimeout(settings.getConnectionTimeout());
        requestConfig.setConnectionRequestTimeout(settings.getConnectionRequestTimeout());
        requestConfig.setSocketTimeout(settings.getSocketTimeout());
        return HttpClientBuilder.create().setUserAgent(this.getUserAgent()).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig.build());
    }

    private String getAcceptHeaderValue() {
        return "application/json;version=1";
    }

    protected HttpClient createHttpClient(String login, String password, String hostname, int port, String protocol, HttpClientBuilder builder) {
        HttpHost host = new HttpHost(hostname, port, protocol);
        CloseableHttpClient httpClient = builder.build();
        LoginSSTRetrievalStrategy strategy = new LoginSSTRetrievalStrategy((HttpClient)httpClient, host, login, password);
        return new GoodDataHttpClient((HttpClient)httpClient, (SSTRetrievalStrategy)strategy);
    }

    private String getUserAgent() {
        Package pkg = Package.getPackage("com.gooddata");
        String clientVersion = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : UNKNOWN_VERSION;
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)HttpClientBuilder.class.getClassLoader());
        String apacheVersion = vi != null ? vi.getRelease() : UNKNOWN_VERSION;
        return String.format("%s/%s (%s; %s) %s/%s", "GoodData-Java-SDK", clientVersion, System.getProperty("os.name"), System.getProperty("java.specification.version"), "Apache-HttpClient", apacheVersion);
    }

    protected final RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void logout() {
        this.getAccountService().logout();
    }

    public ProjectService getProjectService() {
        return this.projectService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public GdcService getGdcService() {
        return this.gdcService;
    }

    public DataStoreService getDataStoreService() {
        return this.dataStoreService;
    }

    public DatasetService getDatasetService() {
        return this.datasetService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public WarehouseService getWarehouseService() {
        return this.warehouseService;
    }

    public ConnectorService getConnectorService() {
        return this.connectorService;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public ExportImportService getExportImportService() {
        return this.exportImportService;
    }
}

