/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.gooddata.util.Validate;
import java.io.IOException;

public class BooleanIntegerDeserializer
extends JsonDeserializer<Boolean> {
    private static final Integer ONE = 1;

    public Boolean deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode root = (JsonNode)jp.readValueAsTree();
        Validate.notNull(root, "jsonNode");
        if (root.isInt()) {
            return ONE.equals(root.numberValue());
        }
        throw new JsonMappingException("Expected int value: " + root.asText(), jp.getCurrentLocation());
    }
}

