/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.MaqlAst;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import java.util.Collection;

@JsonTypeName(value="metric")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Metric
extends AbstractObj
implements Queryable,
Updatable {
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Metric(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public Metric(String title, String expression, String format) {
        this(new Meta(title), new Content(expression, format));
    }

    @JsonIgnore
    public String getExpression() {
        return this.content.getExpression();
    }

    @JsonIgnore
    public String getFormat() {
        return this.content.getFormat();
    }

    @JsonIgnore
    public MaqlAst getMaqlAst() {
        return this.content.getMaqlAst();
    }

    @JsonIgnore
    public Collection<String> getFolders() {
        return this.content.getFolders();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content {
        private final String expression;
        @JsonProperty(value="format")
        private String format;
        @JsonProperty(value="tree")
        private MaqlAst maqlAst;
        private final Collection<String> folders;

        @JsonCreator
        public Content(@JsonProperty(value="expression") String expression, @JsonProperty(value="folders") Collection<String> folders) {
            this.expression = expression;
            this.folders = folders;
        }

        public Content(String expression, String format) {
            this.expression = expression;
            this.format = format;
            this.folders = null;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }

        public void setMaqlAst(MaqlAst maqlAst) {
            this.maqlAst = maqlAst;
        }

        public MaqlAst getMaqlAst() {
            return this.maqlAst;
        }

        public Collection<String> getFolders() {
            return this.folders;
        }
    }
}

