/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.connector.Status;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.ISODateTimeSerializer;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IntegrationProcessStatus {
    public static final String URI = "/gdc/projects/{project}/connectors/{connector}/integration/processes/{process}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{project}/connectors/{connector}/integration/processes/{process}");
    private static final String SELF_LINK = "self";
    private final Status status;
    private final DateTime started;
    private final DateTime finished;
    private Map<String, String> links;

    @JsonCreator
    protected IntegrationProcessStatus(@JsonProperty(value="status") Status status, @JsonProperty(value="started") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime started, @JsonProperty(value="finished") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime finished, @JsonProperty(value="links") Map<String, String> links) {
        this.status = status;
        this.started = started;
        this.finished = finished;
        this.links = links;
    }

    public Status getStatus() {
        return this.status;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getStarted() {
        return this.started;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getFinished() {
        return this.finished;
    }

    @JsonIgnore
    public boolean isFinished() {
        return this.status != null && this.status.isFinished();
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.status != null && this.status.isFailed();
    }

    @JsonIgnore
    public String getUri() {
        return this.links != null ? this.links.get(SELF_LINK) : null;
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("process");
    }
}

