/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import com.gooddata.md.report.Grid;
import com.gooddata.md.report.ReportDefinitionContent;
import java.util.Map;

@JsonTypeName(value="reportDefinition")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReportDefinition
extends AbstractObj
implements Queryable,
Updatable {
    private static final String EXPLAIN_LINK = "explain2";
    @JsonProperty(value="content")
    private final ReportDefinitionContent content;
    @JsonProperty(value="links")
    private final Map<String, String> links;

    @JsonCreator
    ReportDefinition(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") ReportDefinitionContent content, @JsonProperty(value="links") Map<String, String> links) {
        super(meta);
        this.content = content;
        this.links = links;
    }

    ReportDefinition(Meta meta, ReportDefinitionContent content) {
        this(meta, content, null);
    }

    ReportDefinition(String title, ReportDefinitionContent content) {
        super(new Meta(title));
        this.content = content;
        this.links = null;
    }

    @JsonIgnore
    public String getFormat() {
        return this.content.getFormat();
    }

    @JsonIgnore
    public Grid getGrid() {
        return this.content.getGrid();
    }

    @Deprecated
    @JsonIgnore
    public String getExplainLink() {
        return this.getExplainUri();
    }

    @JsonIgnore
    public String getExplainUri() {
        return this.links != null ? this.links.get(EXPLAIN_LINK) : null;
    }
}

