/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.account;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.account.Account;
import com.gooddata.account.AccountNotFoundException;
import com.gooddata.gdc.UriResponse;
import com.gooddata.util.Validate;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AccountService
extends AbstractService {
    public AccountService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public Account getCurrent() {
        return this.getAccountById("current");
    }

    public void logout() {
        try {
            String id = this.getCurrent().getId();
            this.restTemplate.delete("/gdc/account/login/{id}", new Object[]{id});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to logout", e);
        }
    }

    public Account createAccount(Account account, String organizationName) {
        Validate.notNull(account, "account");
        Validate.notEmpty(organizationName, "organizationName");
        try {
            UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/account/domains/{organization_name}/users", (Object)account, UriResponse.class, new Object[]{organizationName});
            return this.getAccountByUri(uriResponse.getUri());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create account", e);
        }
    }

    public void removeAccount(Account account) {
        Validate.notNull(account, "account");
        try {
            this.restTemplate.delete(account.getUri(), new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(account.getUri(), e);
            }
            throw e;
        }
        catch (GoodDataException e) {
            throw new GoodDataException("Unable to remove account", e);
        }
    }

    public Account getAccountById(String id) {
        try {
            return (Account)this.restTemplate.getForObject("/gdc/account/profile/{id}", Account.class, new Object[]{id});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(Account.TEMPLATE.expand(new Object[]{id}).toString(), e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get account", e);
        }
    }

    public Account getAccountByUri(String uri) {
        return this.getAccountById(Account.getId(uri));
    }

    public void updateAccount(Account account) {
        Validate.notNull(account, "account");
        try {
            MappingJacksonValue jacksonValue = new MappingJacksonValue((Object)account);
            jacksonValue.setSerializationView(Account.UpdateView.class);
            this.restTemplate.put(account.getUri(), (Object)jacksonValue, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(account.getUri(), e);
            }
            throw e;
        }
        catch (GoodDataException e) {
            throw new GoodDataException("Unable to update account", e);
        }
    }
}

