/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.collections.MultiPageList;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.Warehouse;
import com.gooddata.warehouse.WarehouseNotFoundException;
import com.gooddata.warehouse.WarehouseSchema;
import com.gooddata.warehouse.WarehouseSchemaNotFoundException;
import com.gooddata.warehouse.WarehouseSchemas;
import com.gooddata.warehouse.WarehouseTask;
import com.gooddata.warehouse.WarehouseUser;
import com.gooddata.warehouse.WarehouseUserNotFoundException;
import com.gooddata.warehouse.WarehouseUsers;
import com.gooddata.warehouse.Warehouses;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class WarehouseService
extends AbstractService {
    private static final String DEFAULT_SCHEMA_NAME = "default";

    public WarehouseService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public FutureResult<Warehouse> createWarehouse(Warehouse warehouse) {
        WarehouseTask task;
        Validate.notNull(warehouse, "warehouse");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances", (Object)warehouse, WarehouseTask.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create Warehouse", e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when Warehouse POSTed to API");
        }
        return new PollResult<Warehouse>(this, new AbstractPollHandler<WarehouseTask, Warehouse>(task.getPollUri(), WarehouseTask.class, Warehouse.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            protected void onFinish() {
                if (!((Warehouse)this.getResult()).isEnabled()) {
                    throw new GoodDataException("Created warehouse, uri: " + ((Warehouse)this.getResult()).getUri() + " is not enabled!");
                }
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    Warehouse warehouse = (Warehouse)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseUri(), Warehouse.class, new Object[0]);
                    this.setResult(warehouse);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("Warehouse creation finished, but can't get created warehouse, uri: " + pollResult.getWarehouseUri(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to create warehouse", e);
            }
        });
    }

    public void removeWarehouse(Warehouse warehouse) {
        Validate.notNull(warehouse, "warehouse");
        try {
            this.restTemplate.delete(warehouse.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to delete Warehouse, uri: " + warehouse.getUri(), e);
        }
    }

    public Warehouse getWarehouseByUri(String uri) {
        Validate.notEmpty(uri, "uri");
        try {
            return (Warehouse)this.restTemplate.getForObject(uri, Warehouse.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get Warehouse instance " + uri, e);
        }
    }

    public Warehouse getWarehouseById(String id) {
        Validate.notEmpty(id, "id");
        return this.getWarehouseByUri(WarehouseService.uriFromId(id));
    }

    private static String uriFromId(String id) {
        return Warehouse.TEMPLATE.expand(new Object[]{id}).toString();
    }

    public PageableList<Warehouse> listWarehouses() {
        return this.listWarehouses(new PageRequest());
    }

    public PageableList<Warehouse> listWarehouses(Page startPage) {
        Validate.notNull(startPage, "startPage");
        return new MultiPageList<Warehouse>(startPage, page -> this.listWarehouses(this.getWarehousesUri((Page)page)));
    }

    private URI getWarehousesUri() {
        return URI.create("/gdc/datawarehouse/instances");
    }

    private URI getWarehousesUri(Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehousesUri()));
    }

    private PageableList<Warehouse> listWarehouses(URI uri) {
        try {
            Warehouses result = (Warehouses)this.restTemplate.getForObject(uri, Warehouses.class);
            if (result == null) {
                return new PageableList<Warehouse>();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list Warehouses", e);
        }
    }

    public PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse) {
        return this.listWarehouseUsers(warehouse, new PageRequest());
    }

    public PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse, Page startPage) {
        Validate.notNull(warehouse, "warehouse");
        Validate.notNull(warehouse.getId(), "warehouse.id");
        Validate.notNull(startPage, "startPage");
        return new MultiPageList<WarehouseUser>(startPage, page -> this.listWarehouseUsers(warehouse, this.getWarehouseUsersUri(warehouse, (Page)page)));
    }

    private URI getWarehouseUsersUri(Warehouse warehouse) {
        return WarehouseUsers.TEMPLATE.expand(new Object[]{warehouse.getId()});
    }

    private URI getWarehouseUsersUri(Warehouse warehouse, Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehouseUsersUri(warehouse)));
    }

    private PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse, URI uri) {
        try {
            WarehouseUsers result = (WarehouseUsers)this.restTemplate.getForObject(uri, WarehouseUsers.class);
            return result == null ? new PageableList() : result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list users of warehouse " + warehouse.getId(), e);
        }
    }

    public FutureResult<WarehouseUser> addUserToWarehouse(Warehouse warehouse, WarehouseUser user) {
        WarehouseTask task;
        Validate.notNull(user, "user");
        Validate.notNull(warehouse, "warehouse");
        Validate.notNull(warehouse.getId(), "warehouse.id");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances/{id}/users", (Object)user, WarehouseTask.class, new Object[]{warehouse.getId()});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable add user to warehouse " + warehouse.getId(), e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when user POSTed to API");
        }
        return new PollResult<WarehouseUser>(this, new AbstractPollHandler<WarehouseTask, WarehouseUser>(task.getPollUri(), WarehouseTask.class, WarehouseUser.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    WarehouseUser newUser = (WarehouseUser)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseUserUri(), WarehouseUser.class, new Object[0]);
                    this.setResult(newUser);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("User added to warehouse, but can't get it back, uri: " + pollResult.getWarehouseUserUri(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to add user to warehouse", e);
            }
        });
    }

    public FutureResult<Void> removeUserFromWarehouse(WarehouseUser user) {
        WarehouseTask task;
        Validate.notNull(user, "user");
        try {
            task = (WarehouseTask)this.restTemplate.exchange(user.getUri(), HttpMethod.DELETE, null, WarehouseTask.class, new Object[0]).getBody();
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseUserNotFoundException(user.getUri(), e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to remove Warehouse user from instance " + user.getUri(), e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when user removed");
        }
        return new PollResult<Void>(this, new AbstractPollHandler<WarehouseTask, Void>(task.getPollUri(), WarehouseTask.class, Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to remove user from warehouse", e);
            }
        });
    }

    public Warehouse updateWarehouse(Warehouse toUpdate) {
        Validate.notNull(toUpdate, "warehouse to update");
        try {
            this.restTemplate.put(toUpdate.getUri(), (Object)toUpdate, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to update Warehouse, uri: " + toUpdate.getUri());
        }
        return this.getWarehouseByUri(toUpdate.getUri());
    }

    public PageableList<WarehouseSchema> listWarehouseSchemas(Warehouse warehouse) {
        return this.listWarehouseSchemas(warehouse, new PageRequest());
    }

    public PageableList<WarehouseSchema> listWarehouseSchemas(Warehouse warehouse, Page startPage) {
        return new MultiPageList<WarehouseSchema>(startPage, page -> this.listWarehouseSchemas(this.getWarehouseSchemasUri(warehouse, (Page)page)));
    }

    private URI getWarehouseSchemasUri(Warehouse warehouse) {
        return WarehouseSchemas.TEMPLATE.expand(new Object[]{warehouse.getId()});
    }

    private URI getWarehouseSchemasUri(Warehouse warehouse, Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehouseSchemasUri(warehouse)));
    }

    private PageableList<WarehouseSchema> listWarehouseSchemas(URI uri) {
        try {
            WarehouseSchemas result = (WarehouseSchemas)this.restTemplate.getForObject(uri, WarehouseSchemas.class);
            if (result == null) {
                return new PageableList<WarehouseSchema>();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list Warehouse schemas", e);
        }
    }

    public WarehouseSchema getWarehouseSchemaByName(Warehouse warehouse, String name) {
        Validate.notNull(warehouse, "warehouse");
        Validate.notEmpty(name, "name");
        String uri = WarehouseSchema.TEMPLATE.expand(new Object[]{warehouse.getId(), name}).toString();
        return this.getWarehouseSchemaByUri(uri);
    }

    public WarehouseSchema getWarehouseSchemaByUri(String uri) {
        Validate.notEmpty(uri, "uri");
        try {
            return (WarehouseSchema)this.restTemplate.getForObject(uri, WarehouseSchema.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseSchemaNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get Warehouse instance " + uri, e);
        }
    }

    public WarehouseSchema getDefaultWarehouseSchema(Warehouse warehouse) {
        return this.getWarehouseSchemaByName(warehouse, DEFAULT_SCHEMA_NAME);
    }
}

