/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.gooddata.gdc.ErrorStructure;
import com.gooddata.gdc.GdcError;
import java.io.IOException;

class ErrorStructureDeserializer
extends JsonDeserializer<ErrorStructure> {
    private static final String GDC_ERROR_TYPE_NAME = "error";

    ErrorStructureDeserializer() {
    }

    public ErrorStructure deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Class clazz;
        TokenBuffer tokenBuffer = new TokenBuffer(jp);
        tokenBuffer.copyCurrentStructure(jp);
        TreeNode treeNode = tokenBuffer.asParser().readValueAsTree();
        if (treeNode.isObject()) {
            clazz = ((ObjectNode)treeNode).has(GDC_ERROR_TYPE_NAME) ? GdcError.class : DefaultDeserializerErrorStructure.class;
        } else {
            throw ctxt.mappingException("Unknown type of ErrorStructure");
        }
        JsonParser nextParser = tokenBuffer.asParser();
        nextParser.nextToken();
        return (ErrorStructure)ctxt.readValue(nextParser, clazz);
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    private static class DefaultDeserializerErrorStructure
    extends ErrorStructure {
        protected DefaultDeserializerErrorStructure(@JsonProperty(value="errorClass") String errorClass, @JsonProperty(value="component") String component, @JsonProperty(value="parameters") Object[] parameters, @JsonProperty(value="message") String message, @JsonProperty(value="errorCode") String errorCode, @JsonProperty(value="errorId") String errorId, @JsonProperty(value="trace") String trace, @JsonProperty(value="requestId") String requestId) {
            super(errorClass, component, parameters, message, errorCode, errorId, trace, requestId);
        }
    }
}

