/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.export;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.GoodDataEndpoint;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="clientExport")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class ClientExport {
    private static final String DASHBOARD_EXPORT_URI = "/dashboard.html#project={projectUri}&dashboard={dashboardUri}&tab={tabId}&export=1";
    private static final UriTemplate DASHBOARD_EXPORT_TEMPLATE = new UriTemplate("/dashboard.html#project={projectUri}&dashboard={dashboardUri}&tab={tabId}&export=1");
    private final String url;
    private final String name;

    ClientExport(String url, String name) {
        this.url = Validate.notEmpty(url, "url");
        this.name = Validate.notEmpty(name, "name");
    }

    ClientExport(GoodDataEndpoint endpoint, String projectUri, String dashboardUri, String tabId) {
        this(Validate.notNull(endpoint, "endpoint").toUri() + DASHBOARD_EXPORT_TEMPLATE.expand(new Object[]{Validate.notNull(projectUri, "projectUri"), Validate.notNull(dashboardUri, "dashboardUri"), Validate.notNull(tabId, "tabId")}).toString(), "export.pdf");
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

