/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.notification;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="projectEvent")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
public class ProjectEvent {
    public static final String URI = "/gdc/projects/{projectId}/notifications/events";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/notifications/events");
    private final String type;
    private final Map<String, String> parameters;

    public ProjectEvent(String type) {
        this(type, new HashMap<String, String>());
    }

    public ProjectEvent(String type, Map<String, String> parameters) {
        Validate.notEmpty((CharSequence)type, (String)"type");
        Validate.notNull(parameters, (String)"parameters");
        this.type = type;
        this.parameters = parameters;
    }

    public void setParameter(String key, String value) {
        Validate.notNull((Object)key, (String)"parameter key");
        Validate.notNull((Object)value, (String)"parameter value");
        this.parameters.put(key, value);
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectEvent)) {
            return false;
        }
        ProjectEvent that = (ProjectEvent)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.parameters == null ? that.parameters != null : !this.parameters.equals(that.parameters));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

