/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.collections.Paging;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class MultiPageList<T>
extends PageableList<T> {
    private final PageableList<T> delegate;
    private final Function<Page, PageableList<T>> pageProvider;

    public MultiPageList(Function<Page, PageableList<T>> pageProvider) {
        this((Page)new PageRequest(), pageProvider);
    }

    public MultiPageList(Page startPage, Function<Page, PageableList<T>> pageProvider) {
        this((PageableList)((Function)Validate.notNull(pageProvider, (String)"pageProvider can't be null", (Object[])new Object[0])).apply(startPage), pageProvider);
    }

    MultiPageList(PageableList<T> delegate, Function<Page, PageableList<T>> pageProvider) {
        this.delegate = (PageableList)Validate.notNull(delegate, (String)"delegate can't be null", (Object[])new Object[0]);
        this.pageProvider = (Function)Validate.notNull(pageProvider, (String)"pageProvider can't be null", (Object[])new Object[0]);
    }

    public Iterator<T> iterator() {
        return new PageIterator<T>(this.delegate, this.pageProvider);
    }

    public List<T> getCurrentPageItems() {
        return this.delegate.getCurrentPageItems();
    }

    public List<T> collectAll() {
        return this.stream().collect(Collectors.toList());
    }

    public Page getNextPage() {
        return this.delegate.getNextPage();
    }

    public boolean hasNextPage() {
        return this.delegate.hasNextPage();
    }

    public Map<String, String> getLinks() {
        return this.delegate.getLinks();
    }

    public Paging getPaging() {
        return this.delegate.getPaging();
    }

    public int size() {
        return this.delegate.size();
    }

    public int totalSize() {
        return (int)this.stream().count();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray((Object[])a);
    }

    public boolean add(T item) {
        return this.delegate.add(item);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends T> c) {
        return this.delegate.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public void clear() {
        this.delegate.clear();
    }

    public T get(int index) {
        return (T)this.delegate.get(index);
    }

    public T set(int index, T element) {
        return (T)this.delegate.set(index, element);
    }

    public void add(int index, T element) {
        this.delegate.add(index, element);
    }

    public T remove(int index) {
        return (T)this.delegate.remove(index);
    }

    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class PageIterator<T>
    implements Iterator<T> {
        private PageableList<T> currentPage;
        private Iterator<T> pageItemsIterator;
        private final Function<Page, PageableList<T>> pageProvider;

        PageIterator(PageableList<T> currentPage, Function<Page, PageableList<T>> pageProvider) {
            this.pageProvider = pageProvider;
            this.currentPage = currentPage;
            this.pageItemsIterator = currentPage.getItemsIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.pageItemsIterator.hasNext()) {
                return true;
            }
            if (this.currentPage.getNextPage() == null) {
                return false;
            }
            PageableList<T> next = this.pageProvider.apply(this.currentPage.getNextPage());
            if (this.currentPage.getNextPage().equals(next.getNextPage())) {
                throw new IllegalStateException("page provider does not iterate properly, returns the same page");
            }
            if (next.isEmpty() && next.getNextPage() != null) {
                throw new IllegalStateException("page has no results, yet claims there is next page");
            }
            this.currentPage = next;
            this.pageItemsIterator = this.currentPage.getItemsIterator();
            return this.pageItemsIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.pageItemsIterator.hasNext()) {
                throw new NoSuchElementException("no more items left");
            }
            return this.pageItemsIterator.next();
        }
    }
}

