/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.BooleanStringSerializer;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonTypeName(value="dataSet")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Dataset
extends AbstractObj
implements Queryable,
Updatable {
    private static final String DATA_UPLOADS_LINK = "dataUploads";
    private static final String UPLOAD_CONFIGURATION_LINK = "uploadConfiguration";
    @JsonProperty(value="content")
    private final Content content;
    @JsonProperty(value="links")
    private final Map<String, String> links;

    @JsonCreator
    private Dataset(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content, @JsonProperty(value="links") Map<String, String> links) {
        super(meta);
        this.content = content;
        this.links = links;
    }

    Dataset(String title) {
        this(new Meta(title), new Content(Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false), null);
    }

    @JsonIgnore
    public List<String> getTies() {
        return this.content.getTies();
    }

    @JsonIgnore
    public String getMode() {
        return this.content.getMode();
    }

    @JsonIgnore
    public List<String> getFacts() {
        return this.content.getFacts();
    }

    @JsonIgnore
    public List<String> getDataLoadingColumns() {
        return this.content.getDataLoadingColumns();
    }

    @JsonIgnore
    public List<String> getAttributes() {
        return this.content.getAttributes();
    }

    @JsonIgnore
    public boolean hasUploadConfiguration() {
        return Boolean.TRUE.equals(this.content.hasUploadConfiguration());
    }

    @Deprecated
    @JsonIgnore
    public String getDataUploadsLink() {
        return this.getDataUploadsUri();
    }

    @JsonIgnore
    public String getDataUploadsUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(DATA_UPLOADS_LINK);
    }

    @Deprecated
    @JsonIgnore
    public String getUploadConfigurationLink() {
        return this.getUploadConfigurationUri();
    }

    @JsonIgnore
    public String getUploadConfigurationUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(UPLOAD_CONFIGURATION_LINK);
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content {
        private final List<String> ties;
        private final String mode;
        private final List<String> facts;
        private final List<String> dataLoadingColumns;
        private final List<String> attributes;
        private final Boolean hasUploadConfiguration;

        @JsonCreator
        private Content(@JsonProperty(value="ties") List<String> ties, @JsonProperty(value="mode") String mode, @JsonProperty(value="facts") List<String> facts, @JsonProperty(value="dataLoadingColumns") List<String> dataLoadingColumns, @JsonProperty(value="attributes") List<String> attributes, @JsonProperty(value="hasUploadConfiguration") @JsonDeserialize(using=BooleanDeserializer.class) Boolean hasUploadConfiguration) {
            this.ties = ties;
            this.mode = mode;
            this.facts = facts;
            this.dataLoadingColumns = dataLoadingColumns;
            this.attributes = attributes;
            this.hasUploadConfiguration = hasUploadConfiguration;
        }

        public List<String> getTies() {
            return this.ties;
        }

        public String getMode() {
            return this.mode;
        }

        public List<String> getFacts() {
            return this.facts;
        }

        public List<String> getDataLoadingColumns() {
            return this.dataLoadingColumns;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        @JsonProperty(value="hasUploadConfiguration")
        @JsonSerialize(using=BooleanStringSerializer.class)
        public Boolean hasUploadConfiguration() {
            return this.hasUploadConfiguration;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

