/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.md.Obj;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.BooleanStringSerializer;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.beans.Introspector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@JsonTypeName(value="inUseMany")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class InUseMany {
    public static final String USEDBY_URI = "/gdc/md/{projectId}/usedby2";
    private final Collection<String> uris;
    private final Set<String> types;
    private final boolean nearest;

    @JsonCreator
    InUseMany(@JsonProperty(value="uris") Collection<String> uris, @JsonProperty(value="nearest") @JsonDeserialize(using=BooleanDeserializer.class) boolean nearest, @JsonProperty(value="types") Set<String> types) {
        this.uris = Validate.notEmpty(uris, (String)"uris");
        this.types = types;
        this.nearest = nearest;
    }

    @SafeVarargs
    public InUseMany(Collection<String> uris, boolean nearest, Class<? extends Obj> ... type) {
        this.uris = (Collection)Validate.notNull(uris, (String)"uris");
        Validate.noNullElements((Object[])type, (String)"type");
        this.types = new HashSet<String>();
        for (Class<? extends Obj> t : type) {
            this.types.add(Introspector.decapitalize(t.getSimpleName()));
        }
        this.nearest = nearest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InUseMany inUseMany = (InUseMany)o;
        if (this.nearest != inUseMany.nearest) {
            return false;
        }
        if (this.uris != null ? !this.uris.equals(inUseMany.uris) : inUseMany.uris != null) {
            return false;
        }
        return this.types != null ? this.types.equals(inUseMany.types) : inUseMany.types == null;
    }

    public int hashCode() {
        int result = this.uris != null ? this.uris.hashCode() : 0;
        result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
        result = 31 * result + (this.nearest ? 1 : 0);
        return result;
    }

    public Collection<String> getUris() {
        return this.uris;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    @JsonSerialize(using=BooleanStringSerializer.class)
    public boolean isNearest() {
        return this.nearest;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

