/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.dataset.UploadMode;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.GDDateTimeDeserializer;
import com.gooddata.util.GoodDataToStringBuilder;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="dataUpload")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Upload {
    public static final String URI = "/gdc/md/{projectId}/data/upload/{uploadId}";
    public static final UriTemplate URI_TEMPLATE = new UriTemplate("/gdc/md/{projectId}/data/upload/{uploadId}");
    private final String uri;
    private final String status;
    private final double progress;
    private final String message;
    private final UploadMode uploadMode;
    private final Integer size;
    private final DateTime createdAt;
    private final DateTime processedAt;

    Upload(@JsonProperty(value="msg") String message, @JsonProperty(value="progress") Double progress, @JsonProperty(value="status") String status, @JsonProperty(value="fullUpload") @JsonDeserialize(using=BooleanDeserializer.class) Boolean fullUpload, @JsonProperty(value="uri") String uri, @JsonProperty(value="createdAt") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime createdAt, @JsonProperty(value="fileSize") Integer size, @JsonProperty(value="processedAt") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime processedAt) {
        this.uri = uri;
        this.status = status;
        this.progress = progress != null ? progress : 0.0;
        this.message = message;
        this.uploadMode = this.toUploadMode(fullUpload);
        this.size = size;
        this.createdAt = createdAt;
        this.processedAt = processedAt;
    }

    public String getUri() {
        return this.uri;
    }

    public String getStatus() {
        return this.status;
    }

    public double getProgress() {
        return this.progress;
    }

    public String getMessage() {
        return this.message;
    }

    public UploadMode getUploadMode() {
        return this.uploadMode;
    }

    public Integer getSize() {
        return this.size;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public DateTime getProcessedAt() {
        return this.processedAt;
    }

    private UploadMode toUploadMode(Boolean fullUpload) {
        if (fullUpload == null) {
            return null;
        }
        return fullUpload != false ? UploadMode.FULL : UploadMode.INCREMENTAL;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

