/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.result;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.executeafm.result.DataList;
import com.gooddata.executeafm.result.DataValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonDeserialize(using=DataDeserializer.class)
public interface Data {
    public static final Data NULL = new Data(){

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isValue() {
            return false;
        }

        @Override
        @JsonValue
        public String textValue() {
            return null;
        }
    };

    public boolean isList();

    public boolean isValue();

    default public boolean isNull() {
        return this == NULL;
    }

    public String textValue();

    default public List<Data> asList() {
        throw new UnsupportedOperationException("This is not a list");
    }

    public static class DataDeserializer
    extends JsonDeserializer<Data> {
        public Data deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode root = (JsonNode)jp.readValueAsTree();
            if (root.isArray()) {
                List<Data> list = StreamSupport.stream(Spliterators.spliteratorUnknownSize(root.elements(), 16), false).map(elem -> {
                    try {
                        return (Data)ctxt.readValue(elem.traverse(jp.getCodec()), Data.class);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }).collect(Collectors.toList());
                return new DataList(list);
            }
            if (root.isTextual()) {
                return new DataValue(root.textValue());
            }
            if (root.isNull()) {
                return NULL;
            }
            throw JsonMappingException.from((JsonParser)jp, (String)("Unknown value of type: " + root.getNodeType()));
        }

        public Data getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return NULL;
        }
    }
}

