/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.projecttemplate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.util.BooleanDeserializer;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="projectTemplate")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Template {
    private final String uri;
    private final String urn;
    private final String version;
    private final Boolean hidden;
    private final Content content;
    private final Meta meta;

    @JsonCreator
    private Template(@JsonProperty(value="link") String uri, @JsonProperty(value="urn") String urn, @JsonProperty(value="version") String version, @JsonProperty(value="hidden") @JsonDeserialize(using=BooleanDeserializer.class) Boolean hidden, @JsonProperty(value="content") Content content, @JsonProperty(value="meta") Meta meta) {
        this.uri = uri;
        this.urn = urn;
        this.version = version;
        this.hidden = hidden;
        this.content = content;
        this.meta = meta;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUrn() {
        return this.urn;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public String getMdDefinitionUri() {
        return this.content != null ? this.content.getMdDefinitionUri() : null;
    }

    public String getDwDefinitionUri() {
        return this.content != null ? this.content.getDwDefinitionUri() : null;
    }

    public String getConfigUri() {
        return this.content != null ? this.content.getConfigUri() : null;
    }

    public List<String> getManifestsUris() {
        return this.content != null ? this.content.getManifestsUris() : null;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        return Objects.equals(this.uri, template.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Author {
        private final String name;
        private final String uri;

        @JsonCreator
        private Author(@JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Meta {
        private final String summary;
        private final String title;
        private final String category;
        private final String apiVersion;
        private final Author author;

        @JsonCreator
        private Meta(@JsonProperty(value="summary") String summary, @JsonProperty(value="title") String title, @JsonProperty(value="category") String category, @JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="author") Author author) {
            this.summary = summary;
            this.title = title;
            this.category = category;
            this.apiVersion = apiVersion;
            this.author = author;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCategory() {
            return this.category;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public Author getAuthor() {
            return this.author;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Content {
        private final String mdDefinitionUri;
        private final String dwDefinitionUri;
        private final String configUri;
        private final List<String> manifestsUris;

        @JsonCreator
        private Content(@JsonProperty(value="MDDefinition") String mdDefinitionUri, @JsonProperty(value="DWDefinition") String dwDefinitionUri, @JsonProperty(value="config") String configUri, @JsonProperty(value="manifests") List<String> manifestsUris) {
            this.mdDefinitionUri = mdDefinitionUri;
            this.dwDefinitionUri = dwDefinitionUri;
            this.configUri = configUri;
            this.manifestsUris = manifestsUris;
        }

        public String getMdDefinitionUri() {
            return this.mdDefinitionUri;
        }

        public String getDwDefinitionUri() {
            return this.dwDefinitionUri;
        }

        public String getConfigUri() {
            return this.configUri;
        }

        public List<String> getManifestsUris() {
            return this.manifestsUris;
        }
    }
}

