/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.connector.ConnectorException;
import com.gooddata.connector.ConnectorType;
import com.gooddata.connector.CoupaInstance;
import com.gooddata.connector.CoupaInstances;
import com.gooddata.connector.CoupaSettings;
import com.gooddata.connector.Integration;
import com.gooddata.connector.IntegrationNotFoundException;
import com.gooddata.connector.IntegrationProcessStatus;
import com.gooddata.connector.PardotSettings;
import com.gooddata.connector.ProcessExecution;
import com.gooddata.connector.ProcessStatus;
import com.gooddata.connector.Settings;
import com.gooddata.connector.Zendesk4Settings;
import com.gooddata.gdc.UriResponse;
import com.gooddata.project.Project;
import com.gooddata.project.ProjectService;
import com.gooddata.project.ProjectTemplate;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ConnectorService
extends AbstractService {
    private final ProjectService projectService;

    public ConnectorService(RestTemplate restTemplate, ProjectService projectService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.projectService = (ProjectService)Validate.notNull((Object)projectService, (String)"projectService");
    }

    @Deprecated
    public ConnectorService(RestTemplate restTemplate, ProjectService projectService) {
        super(restTemplate);
        this.projectService = (ProjectService)Validate.notNull((Object)projectService, (String)"projectService");
    }

    public Integration getIntegration(Project project, ConnectorType connectorType) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)((Object)connectorType), (String)"connector");
        try {
            return (Integration)this.restTemplate.getForObject("/gdc/projects/{project}/connectors/{connector}/integration", Integration.class, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new IntegrationNotFoundException(project, connectorType, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new ConnectorException("Unable to get " + (Object)((Object)connectorType) + " integration", e);
        }
    }

    public Integration createIntegration(Project project, Settings settings) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)settings, (String)"settings");
        Collection<ProjectTemplate> projectTemplates = this.projectService.getProjectTemplates(project);
        if (projectTemplates == null || projectTemplates.isEmpty()) {
            throw new GoodDataException("Project " + project.getId() + " doesn't contain a template reference");
        }
        ProjectTemplate template = (ProjectTemplate)Validate.notNull((Object)projectTemplates.iterator().next(), (String)"project template");
        Integration integration = this.createIntegration(project, settings.getConnectorType(), new Integration(template.getUrl()));
        this.updateSettings(project, settings);
        return integration;
    }

    public Integration createIntegration(Project project, ConnectorType connectorType, Integration integration) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)((Object)connectorType), (String)"connectorType");
        Validate.notNull((Object)integration, (String)"integration");
        try {
            return (Integration)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/{connector}/integration", (Object)integration, Integration.class, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to create " + (Object)((Object)connectorType) + " integration", e);
        }
    }

    public void updateIntegration(Project project, ConnectorType connectorType, Integration integration) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)((Object)connectorType), (String)"connector");
        Validate.notNull((Object)integration, (String)"integration");
        try {
            this.restTemplate.put("/gdc/projects/{project}/connectors/{connector}/integration", (Object)integration, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new IntegrationNotFoundException(project, connectorType, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new ConnectorException("Unable to update " + (Object)((Object)connectorType) + " integration", e);
        }
    }

    public Zendesk4Settings getZendesk4Settings(Project project) {
        return this.getSettings(project, ConnectorType.ZENDESK4, Zendesk4Settings.class);
    }

    public CoupaSettings getCoupaSettings(Project project) {
        return this.getSettings(project, ConnectorType.COUPA, CoupaSettings.class);
    }

    public PardotSettings getPardotSettings(Project project) {
        return this.getSettings(project, ConnectorType.PARDOT, PardotSettings.class);
    }

    public CoupaInstance createCoupaInstance(Project project, CoupaInstance instance) {
        UriResponse instanceUri;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)instance, (String)"instance");
        try {
            instanceUri = (UriResponse)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/coupa/integration/config/settings/instances", (Object)instance, UriResponse.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to create Coupa instance with API URL '" + instance.getApiUrl() + "'", e);
        }
        try {
            return (CoupaInstance)this.restTemplate.getForObject(instanceUri.getUri(), CoupaInstance.class, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to get created Coupa instance with URI '" + instanceUri.getUri() + "'", e);
        }
    }

    public Collection<CoupaInstance> findCoupaInstances(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            CoupaInstances instances = (CoupaInstances)this.restTemplate.getForObject("/gdc/projects/{project}/connectors/coupa/integration/config/settings/instances", CoupaInstances.class, new Object[]{project.getId()});
            if (instances == null) {
                throw new ConnectorException("Empty response from API call.");
            }
            if (instances.getItems() == null) {
                return Collections.emptyList();
            }
            return instances.getItems();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to get Coupa instances.", e);
        }
    }

    public <T extends Settings> T getSettings(Project project, ConnectorType connectorType, Class<T> settingsClass) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)((Object)connectorType), (String)"connectorType");
        Validate.notNull(settingsClass, (String)"settingsClass");
        try {
            return (T)((Settings)this.restTemplate.getForObject(connectorType.getSettingsUrl(), settingsClass, new Object[]{project.getId()}));
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to get " + (Object)((Object)connectorType) + " integration settings", e);
        }
    }

    public void updateSettings(Project project, Settings settings) {
        Validate.notNull((Object)settings, (String)"settings");
        Validate.notNull((Object)((Object)settings.getConnectorType()), (String)"settings.connectorType");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)project, (String)"project");
        try {
            this.restTemplate.put(settings.getConnectorType().getSettingsUrl(), (Object)settings, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to set " + (Object)((Object)settings.getConnectorType()) + " settings", e);
        }
    }

    public FutureResult<ProcessStatus> executeProcess(Project project, ProcessExecution execution) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)execution, (String)"execution");
        String connectorType = execution.getConnectorType().getName();
        try {
            UriResponse response = (UriResponse)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/{connector}/integration/processes", (Object)execution, UriResponse.class, new Object[]{project.getId(), connectorType});
            return this.createProcessPollResult(response.getUri());
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to execute " + connectorType + " process", e);
        }
    }

    public FutureResult<ProcessStatus> getProcessStatus(IntegrationProcessStatus process) {
        Validate.notNull((Object)process, (String)"process");
        Validate.notNull((Object)process.getUri(), (String)"process.getUri");
        return this.createProcessPollResult(process.getUri());
    }

    protected FutureResult<ProcessStatus> createProcessPollResult(String uri) {
        Map match = IntegrationProcessStatus.TEMPLATE.match(uri);
        final String connectorType = (String)match.get("connector");
        final String processId = (String)match.get("process");
        return new PollResult<ProcessStatus>(this, new SimplePollHandler<ProcessStatus>(uri, ProcessStatus.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                ProcessStatus process = (ProcessStatus)ConnectorService.this.extractData(response, ProcessStatus.class);
                return process.isFinished();
            }

            @Override
            public void handlePollResult(ProcessStatus pollResult) {
                super.handlePollResult(pollResult);
                if (pollResult.isFailed()) {
                    throw new ConnectorException(String.format("%s process %s failed: %s", connectorType, processId, pollResult.getStatus().getDescription()));
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ConnectorException(String.format("%s process %s failed: %s", connectorType, processId, e.getText()), e);
            }
        });
    }
}

