/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.Attribute;
import com.gooddata.md.DisplayForm;
import com.gooddata.md.report.GridElement;
import com.gooddata.md.report.Total;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeName(value="attribute")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AttributeInGrid
implements GridElement {
    private final String uri;
    private final String alias;
    private final List<List<String>> totals;

    @JsonCreator
    AttributeInGrid(@JsonProperty(value="uri") String uri, @JsonProperty(value="totals") List<List<String>> totals, @JsonProperty(value="alias") String alias) {
        this.uri = uri;
        this.alias = alias;
        this.totals = totals;
    }

    @Deprecated
    public AttributeInGrid(String uri) {
        this(uri, "");
    }

    public AttributeInGrid(String uri, String alias) {
        this(uri, new ArrayList<List<String>>(), alias);
    }

    public AttributeInGrid(String uri, String alias, List<List<Total>> totals) {
        this(uri, alias);
        Validate.notNull(totals, "totals");
        for (List<Total> totalList : totals) {
            ArrayList totalStringList = new ArrayList(totalList.size());
            totalStringList.addAll(totalList.stream().map(Total::toString).collect(Collectors.toList()));
            this.totals.add(totalStringList);
        }
    }

    public AttributeInGrid(DisplayForm displayForm) {
        this(Validate.notNull(Validate.notNull(displayForm, "displayForm").getUri(), "uri"), Validate.notNull(displayForm, "displayForm").getTitle());
    }

    public AttributeInGrid(DisplayForm displayForm, String alias) {
        this(Validate.notNull(Validate.notNull(displayForm, "displayForm").getUri(), "uri"), alias);
    }

    public AttributeInGrid(Attribute attribute) {
        this(Validate.notNull(attribute, "attribute").getDefaultDisplayForm(), Validate.notNull(attribute, "attribute").getTitle());
    }

    public AttributeInGrid(Attribute attribute, String alias) {
        this(Validate.notNull(attribute, "attribute").getDefaultDisplayForm(), alias);
    }

    @JsonProperty(value="totals")
    public List<List<String>> getStringTotals() {
        return this.totals;
    }

    @JsonIgnore
    public List<List<Total>> getTotals() {
        ArrayList<List<Total>> enumTotals = new ArrayList<List<Total>>(this.totals.size());
        for (List<String> totalList : this.totals) {
            ArrayList totalEnumList = new ArrayList(totalList.size());
            totalEnumList.addAll(totalList.stream().map(Total::of).collect(Collectors.toList()));
            enumTotals.add(totalEnumList);
        }
        return enumTotals;
    }

    public String getUri() {
        return this.uri;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

