/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.gdc.UriResponse;
import com.gooddata.md.report.Report;
import com.gooddata.md.report.ReportDefinition;
import com.gooddata.report.ExecuteDefinition;
import com.gooddata.report.ExecuteReport;
import com.gooddata.report.NoDataReportException;
import com.gooddata.report.ReportException;
import com.gooddata.report.ReportExportFormat;
import com.gooddata.report.ReportRequest;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ReportService
extends AbstractService {
    public static final String EXPORTING_URI = "/gdc/exporter/executor";

    public ReportService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public FutureResult<Void> exportReport(ReportDefinition reportDefinition, ReportExportFormat format, OutputStream output) {
        Validate.notNull(reportDefinition, "reportDefinition");
        ExecuteDefinition request = new ExecuteDefinition(reportDefinition.getUri());
        return this.exportReport(request, format, output);
    }

    public FutureResult<Void> exportReport(Report report, ReportExportFormat format, OutputStream output) {
        Validate.notNull(report, "report");
        ExecuteReport request = new ExecuteReport(report.getUri());
        return this.exportReport(request, format, output);
    }

    private FutureResult<Void> exportReport(ReportRequest request, ReportExportFormat format, final OutputStream output) {
        Validate.notNull(output, "output");
        Validate.notNull(format, "format");
        JsonNode execResult = this.executeReport(request);
        final String uri = this.exportReport(execResult, format);
        return new PollResult<Void>(this, new SimplePollHandler<Void>(uri, Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                switch (response.getStatusCode()) {
                    case OK: {
                        return true;
                    }
                    case ACCEPTED: {
                        return false;
                    }
                    case NO_CONTENT: {
                        throw new NoDataReportException();
                    }
                }
                throw new ReportException("Unable to export report, unknown HTTP response code: " + response.getStatusCode());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ReportException("Unable to export report", e);
            }

            @Override
            protected void onFinish() {
                try {
                    ReportService.this.restTemplate.execute(uri, HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(output), new Object[0]);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ReportException("Unable to export report", e);
                }
            }
        });
    }

    private JsonNode executeReport(ReportRequest request) {
        try {
            ResponseEntity entity = this.restTemplate.exchange("/gdc/xtab2/executor3", HttpMethod.POST, new HttpEntity((Object)request), String.class, new Object[0]);
            return this.mapper.readTree((String)entity.getBody());
        }
        catch (GoodDataException | RestClientException e) {
            throw new ReportException("Unable to execute report", e);
        }
        catch (IOException e) {
            throw new ReportException("Unable to read execution result", e);
        }
    }

    private String exportReport(JsonNode execResult, ReportExportFormat format) {
        Validate.notNull(execResult, "execResult");
        Validate.notNull(format, "format");
        ObjectNode root = this.mapper.createObjectNode();
        ObjectNode child = this.mapper.createObjectNode();
        child.set("result", execResult);
        child.put("format", format.getValue());
        root.set("result_req", (JsonNode)child);
        try {
            return ((UriResponse)this.restTemplate.postForObject(EXPORTING_URI, (Object)root, UriResponse.class, new Object[0])).getUri();
        }
        catch (GoodDataException | RestClientException e) {
            throw new ReportException("Unable to export report", e);
        }
    }
}

