/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.afm;

import com.gooddata.executeafm.IdentifierObjQualifier;
import com.gooddata.executeafm.ObjQualifier;
import com.gooddata.executeafm.UriObjQualifier;
import com.gooddata.executeafm.afm.ObjQualifierConverter;
import com.gooddata.util.Validate;
import java.util.function.Function;

abstract class ObjIdentifierUtilities {
    ObjIdentifierUtilities() {
    }

    static <R> R copyIfNecessary(R objectToBeCopied, ObjQualifier qualifierForPossibleConversion, Function<UriObjQualifier, R> objectCopyFactory, ObjQualifierConverter qualifierConverter) {
        Validate.notNull(objectToBeCopied, (String)"objectToBeCopied");
        Validate.notNull((Object)qualifierForPossibleConversion, (String)"qualifierForPossibleConversion");
        Validate.notNull(objectCopyFactory, (String)"objectCopyFactory");
        Validate.notNull((Object)qualifierConverter, (String)"qualifierConverter");
        if (qualifierForPossibleConversion instanceof IdentifierObjQualifier) {
            IdentifierObjQualifier identifierQualifierToConvert = (IdentifierObjQualifier)qualifierForPossibleConversion;
            return ObjIdentifierUtilities.copyWithUriQualifier(identifierQualifierToConvert, objectCopyFactory, qualifierConverter);
        }
        return objectToBeCopied;
    }

    private static <R> R copyWithUriQualifier(IdentifierObjQualifier identifierQualifierToConvert, Function<UriObjQualifier, R> objectCopyFactory, ObjQualifierConverter qualifierConverter) {
        return qualifierConverter.convertToUriQualifier(identifierQualifierToConvert).map(objectCopyFactory).orElseThrow(() -> ObjIdentifierUtilities.buildExceptionForFailedConversion(identifierQualifierToConvert));
    }

    private static IllegalArgumentException buildExceptionForFailedConversion(IdentifierObjQualifier qualifierFailedToConvert) {
        return new IllegalArgumentException(String.format("Supplied converter does not provide conversion for '%s'!", qualifierFailedToConvert));
    }
}

